/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.anti_mob_cheese.main;

import com.mojang.brigadier.CommandDispatcher;
import com.robertx22.anti_mob_cheese.anti_mob_farm.AntiMobFarmCap;
import com.robertx22.anti_mob_cheese.anti_mob_farm.ChunkCap;
import com.robertx22.anti_mob_cheese.anti_mob_farm.TestCommand;
import com.robertx22.anti_mob_cheese.anti_mob_farm.WorldTickMinute;
import com.robertx22.anti_mob_cheese.configs.CheeseConfig;
import com.robertx22.anti_mob_cheese.main.ModAction;
import com.robertx22.anti_mob_cheese.mixin_methods.OnDropLoot;
import com.robertx22.library_of_exile.components.EntityInfoComponent;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="anti_mob_farm")
public class CommonInit {
    public CommonInit() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CheeseConfig.commonSpec);
        bus.addListener(this::commonSetupEvent);
        ApiForgeEvents.registerForgeEvent(LivingExperienceDropEvent.class, event -> {
            if (!(event.getEntity() instanceof Player) && OnDropLoot.tryCancel(event.getEntity(), ModAction.VANILLA_EXP)) {
                event.setCanceled(true);
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingDropsEvent.class, event -> {
            if (!(event.getEntity() instanceof Player) && OnDropLoot.tryCancel(event.getEntity(), ModAction.VANILLA_LOOT)) {
                event.setCanceled(true);
            }
        });
        ApiForgeEvents.registerForgeEvent(RegisterCommandsEvent.class, event -> TestCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
        ApiForgeEvents.registerForgeEvent(TickEvent.LevelTickEvent.class, event -> {
            if (event.level instanceof ServerLevel && event.phase == TickEvent.Phase.END) {
                WorldTickMinute.onEndTick((ServerLevel)event.level);
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingDeathEvent.class, event -> {
            try {
                if (!(event.getEntity() instanceof Player) && !event.getEntity().m_9236_().f_46443_) {
                    LivingEntity killer;
                    LivingEntity mob = event.getEntity();
                    if (CheeseConfig.get().entityCounts(mob) && ((killer = EntityInfoComponent.get((LivingEntity)mob).getDamageStats().getHighestDamager((ServerLevel)mob.m_9236_())) instanceof Player || !((Boolean)CheeseConfig.get().ONLY_AFFECT_MOBS_KILLED_BY_PLAYER.get()).booleanValue())) {
                        AntiMobFarmCap.get(mob.m_9236_()).onValidMobDeathByPlayer(mob);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ExileEvents.ON_CHEST_LOOTED.register((EventConsumer)new EventConsumer<ExileEvents.OnChestLooted>(){

            public void accept(ExileEvents.OnChestLooted event) {
                try {
                    ChunkPos start = new ChunkPos(event.pos);
                    AntiMobFarmCap.get(event.player.m_9236_()).onLootChestOpened(start);
                    ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
                    chunks.add(start);
                    int radius = 1;
                    for (int x = -radius; x < radius; ++x) {
                        for (int z = -radius; z < radius; ++z) {
                            chunks.add(new ChunkPos(start.f_45578_ + x, start.f_45579_ + z));
                        }
                    }
                    for (ChunkPos chunk : chunks) {
                        ChunkCap.get(event.player.m_9236_().m_6325_(chunk.f_45578_, chunk.f_45579_)).onLootChestOpened();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ExileEvents.SETUP_LOOT_CHANCE.register((EventConsumer)new EventConsumer<ExileEvents.OnSetupLootChance>(){

            public void accept(ExileEvents.OnSetupLootChance event) {
                if (CheeseConfig.get().affects(ModAction.AOE_LOOT) && event.mobKilled != null) {
                    if (!CheeseConfig.get().playerDidEnoughDamageTo(event.mobKilled, ModAction.AOE_LOOT)) {
                        event.lootChance = 0.0f;
                    }
                    if (((Boolean)CheeseConfig.get().ENABLE_ANTI_MOB_FARM.get()).booleanValue() && CheeseConfig.get().affects(ModAction.AOE_LOOT)) {
                        float multi = AntiMobFarmCap.get(event.mobKilled.m_9236_()).getDropMultiForMob(event.mobKilled);
                        event.lootChance *= multi;
                    }
                }
            }
        });
        ExileEvents.MOB_EXP_DROP.register((EventConsumer)new EventConsumer<ExileEvents.OnMobExpDrop>(){

            public void accept(ExileEvents.OnMobExpDrop event) {
                if (CheeseConfig.get().affects(ModAction.AOE_EXP) && event.mobKilled != null) {
                    if (!CheeseConfig.get().playerDidEnoughDamageTo(event.mobKilled, ModAction.AOE_EXP)) {
                        event.exp = 0.0f;
                    }
                    if (((Boolean)CheeseConfig.get().ENABLE_ANTI_MOB_FARM.get()).booleanValue() && CheeseConfig.get().affects(ModAction.AOE_EXP)) {
                        float multi = AntiMobFarmCap.get(event.mobKilled.m_9236_()).getDropMultiForMob(event.mobKilled);
                        event.exp *= multi;
                    }
                }
            }
        });
        System.out.println("Anti Mob Cheese loaded.");
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        ApiForgeEvents.registerForgeEvent(RegisterCapabilitiesEvent.class, x -> {
            x.register(AntiMobFarmCap.class);
            x.register(ChunkCap.class);
        });
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, x -> x.addCapability(AntiMobFarmCap.RESOURCE, (ICapabilityProvider)new AntiMobFarmCap((Level)x.getObject())));
        MinecraftForge.EVENT_BUS.addGenericListener(LevelChunk.class, x -> x.addCapability(ChunkCap.RESOURCE, (ICapabilityProvider)new ChunkCap((LevelChunk)x.getObject())));
    }
}

