/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.anti_mob_cheese.configs;

import com.robertx22.anti_mob_cheese.main.ModAction;
import com.robertx22.library_of_exile.components.EntityInfoComponent;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CheeseConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final CheeseConfig COMMON;
    public ForgeConfigSpec.ConfigValue<? extends List> DIMENSIONS_EXCLUDED;
    public ForgeConfigSpec.ConfigValue<? extends List> ENTITIES_EXCLUDED;
    public ForgeConfigSpec.BooleanValue ENABLE_ANTI_MOB_FARM;
    public ForgeConfigSpec.BooleanValue USE_DEATH_LOCATION;
    public ForgeConfigSpec.DoubleValue ON_MOB_KILLED_DECREASE_BY;
    public ForgeConfigSpec.DoubleValue ON_MINUTE_PASSED_INCREASE_BY;
    public ForgeConfigSpec.DoubleValue GATEWAYS_MOB_CHANCE_TO_NOT_PROC_PENALTY;
    public ForgeConfigSpec.IntValue FREE_MOB_KILLS_BEFORE_PENALTY_STARTS;
    public ForgeConfigSpec.IntValue ADD_FREE_KILLS_ON_CHEST_LOOT;
    public ForgeConfigSpec.BooleanValue AFFECT_PEACEFUL_ANIMALS;
    private ForgeConfigSpec.BooleanValue AFFECT_VANILLA_LOOT_TABLES;
    private ForgeConfigSpec.BooleanValue AFFECT_VANILLA_EXP_DROPS;
    private ForgeConfigSpec.BooleanValue AFFECT_AGE_OF_EXILE_LOOT;
    private ForgeConfigSpec.BooleanValue AFFECT_AGE_OF_EXILE_EXP;
    public ForgeConfigSpec.BooleanValue ONLY_AFFECT_MOBS_KILLED_BY_PLAYER;
    public ForgeConfigSpec.DoubleValue MIN_PLAYER_DMG_TO_GET_LOOT;

    CheeseConfig(ForgeConfigSpec.Builder b) {
        b.comment("Settings").push("general");
        this.ENABLE_ANTI_MOB_FARM = b.define("enable_anti_mob_farm", true);
        this.USE_DEATH_LOCATION = b.comment("If enabled, the chunk that will get penalty will be the one where the mob died, instead of the one where the mob was spawned in").define("USE_DEATH_LOCATION", false);
        this.AFFECT_PEACEFUL_ANIMALS = b.define("affect_animals", false);
        this.AFFECT_VANILLA_LOOT_TABLES = b.define("affect_vanilla_loot", false);
        this.AFFECT_AGE_OF_EXILE_LOOT = b.define("affect_age_of_exile_loot", true);
        this.AFFECT_AGE_OF_EXILE_EXP = b.define("affect_age_of_exile_exp", true);
        this.AFFECT_VANILLA_EXP_DROPS = b.define("affect_vanilla_exp_drops", false);
        this.ONLY_AFFECT_MOBS_KILLED_BY_PLAYER = b.define("ONLY_AFFECT_MOBS_KILLED_BY_PLAYER", true);
        this.MIN_PLAYER_DMG_TO_GET_LOOT = b.comment("0.5 means Player has to do 50% of the mob's total HP in damage to get loot. This counts any player damage, even multiple players").defineInRange("min_player_dmg_for_loot", 0.5, 0.0, 1.0);
        this.ON_MOB_KILLED_DECREASE_BY = b.comment("Every time you kill a mob, the chunk drop chance (originally 1), gets reduced by this amount").defineInRange("mob_kill_chunk_penalty", 0.02, 0.0, 1.0);
        this.ON_MINUTE_PASSED_INCREASE_BY = b.comment("How much the chunk penalty regenerates passively per minute.").defineInRange("penalty_regen_per_minute", 0.02, 0.0, 1.0);
        this.FREE_MOB_KILLS_BEFORE_PENALTY_STARTS = b.comment("Free kills are kills in a chunk that don't trigger the penalty.").defineInRange("one_time_free_kills_per_chunk", 30, 0, 1000);
        this.ADD_FREE_KILLS_ON_CHEST_LOOT = b.comment("Looting Chests will add this many free kills").defineInRange("added_free_kills_on_chest_looted", 10, 0, 1000);
        this.GATEWAYS_MOB_CHANCE_TO_NOT_PROC_PENALTY = b.comment("Gateway mod specific compatibility, relaxes the penalty for them.").defineInRange("GATEWAYS_MOB_CHANCE_TO_NOT_PROC_PENALTY", 75.0, 0.0, 100.0);
        ArrayList<String> dim = new ArrayList<String>();
        dim.add("mmorpg:dungeon");
        this.DIMENSIONS_EXCLUDED = b.defineList("excluded_dimensions", dim, x -> true);
        this.ENTITIES_EXCLUDED = b.defineList("excluded_entities", new ArrayList(), x -> true);
        b.pop();
    }

    public static CheeseConfig get() {
        return COMMON;
    }

    public boolean affects(ModAction action) {
        if (action == ModAction.AOE_EXP) {
            return (Boolean)this.AFFECT_AGE_OF_EXILE_EXP.get();
        }
        if (action == ModAction.AOE_LOOT) {
            return (Boolean)this.AFFECT_AGE_OF_EXILE_LOOT.get();
        }
        if (action == ModAction.VANILLA_LOOT) {
            return (Boolean)this.AFFECT_VANILLA_LOOT_TABLES.get();
        }
        if (action == ModAction.VANILLA_EXP) {
            return (Boolean)this.AFFECT_VANILLA_EXP_DROPS.get();
        }
        System.out.print("No enum: " + action.name());
        return false;
    }

    public boolean playerDidEnoughDamageTo(LivingEntity entity, ModAction action) {
        if (!this.affects(action)) {
            return true;
        }
        float damageDealt = EntityInfoComponent.get((LivingEntity)entity).getDamageStats().getTotalPlayerDamage();
        if (damageDealt > 0.0f) {
            float damageNeeded = entity.m_21233_() * ((Double)this.MIN_PLAYER_DMG_TO_GET_LOOT.get()).floatValue();
            return damageDealt >= damageNeeded;
        }
        return EntityInfoComponent.get((LivingEntity)entity).getDamageStats().getEnviroOrMobDmg() <= entity.m_21233_() / 2.0f;
    }

    public boolean isDimensionExcluded(Level world) {
        if (MapDimensions.isMap((Level)world)) {
            return true;
        }
        String dimId = world.m_46472_().m_135782_().toString();
        return ((List)CheeseConfig.get().DIMENSIONS_EXCLUDED.get()).contains(dimId);
    }

    public boolean entityCounts(LivingEntity mob) {
        String id = ((Registry)mob.m_9236_().m_9598_().m_6632_(Registries.f_256939_).get()).m_7981_((Object)mob.m_6095_()).toString();
        if (((List)this.ENTITIES_EXCLUDED.get()).contains(id)) {
            return false;
        }
        return (Boolean)this.AFFECT_PEACEFUL_ANIMALS.get() != false || !mob.m_6095_().m_20674_().m_21609_();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CheeseConfig::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CheeseConfig)specPair.getLeft();
    }
}

