/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.anti_mob_cheese.anti_mob_farm;

import com.robertx22.anti_mob_cheese.anti_mob_farm.AntiMobFarmChunkData;
import com.robertx22.anti_mob_cheese.anti_mob_farm.ChunkCap;
import com.robertx22.anti_mob_cheese.configs.CheeseConfig;
import com.robertx22.library_of_exile.components.EntityInfoComponent;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.HashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.ChunkPos;

public class AntiMobFarmData {
    static String GATEWAYS = "gateways.owner";
    private HashMap<String, AntiMobFarmChunkData> map = new HashMap();

    public void onValidMobDeathByPlayer(LivingEntity en) {
        if (en instanceof Slime && en.m_9236_().f_46441_.m_188501_() >= 0.2f) {
            return;
        }
        if (en.getPersistentData().m_128403_(GATEWAYS) && RandomUtils.roll((double)((Double)CheeseConfig.get().GATEWAYS_MOB_CHANCE_TO_NOT_PROC_PENALTY.get()))) {
            return;
        }
        String key = this.getKey(en);
        AntiMobFarmChunkData data = this.map.getOrDefault(key, new AntiMobFarmChunkData());
        ChunkCap chunk = ChunkCap.get(en.m_9236_().m_46745_(en.m_20183_()));
        if (!chunk.isKillFree()) {
            data.onMobDeath();
        } else {
            chunk.onValidMobDeathByPlayer(en);
        }
        this.map.put(key, data);
    }

    public void onNewLootChestOpened(ChunkPos cp) {
        String key = this.getKey(cp);
        AntiMobFarmChunkData data = this.map.getOrDefault(key, new AntiMobFarmChunkData());
        data.onLootChestOpened();
        this.map.put(key, data);
    }

    public float getDropMultiForMob(LivingEntity en) {
        if (CheeseConfig.get().isDimensionExcluded(en.m_9236_())) {
            return 1.0f;
        }
        String key = this.getKey(en);
        if (this.map.containsKey(key)) {
            return this.map.get(key).getDropsMulti();
        }
        return 1.0f;
    }

    public float getDropMultiForChunk(ChunkPos cp) {
        String key = this.getKey(cp);
        if (this.map.containsKey(key)) {
            return this.map.get(key).getDropsMulti();
        }
        return 1.0f;
    }

    public void tickDownAllKillCounters() {
        this.map.entrySet().forEach(x -> ((AntiMobFarmChunkData)x.getValue()).tickDown());
        this.map.entrySet().removeIf(x -> ((AntiMobFarmChunkData)x.getValue()).canBeWipedFromData());
    }

    private String getKey(LivingEntity en) {
        if (((Boolean)CheeseConfig.get().USE_DEATH_LOCATION.get()).booleanValue()) {
            return this.getKey(new ChunkPos(en.m_20183_()));
        }
        return this.getKey(new ChunkPos(EntityInfoComponent.get((LivingEntity)en).getSpawnPos()));
    }

    private String getKey(ChunkPos cp) {
        return cp.f_45578_ + "_" + cp.f_45579_;
    }
}

