/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features.cave;

import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class CaveWallCrystalFeature
extends AbstractCaveFeature<Config> {
    public CaveWallCrystalFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(WorldGenLevel level, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        for (int i = 0; i < config.tries; ++i) {
            Direction facing = (Direction)Util.m_214670_((Object[])Direction.values(), (RandomSource)rand);
            BlockState crystal = (BlockState)config.cystal.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
            BlockPos placePos = pos.m_7918_(rand.m_188503_(config.radius * 2) - config.radius, rand.m_188503_(config.radius * 2) - config.radius, rand.m_188503_(config.radius * 2) - config.radius);
            if (!level.m_46859_(placePos) || !crystal.m_60710_((LevelReader)level, placePos) || EntityUtil.canSeeSkyFromBelowWater((LevelReader)level, null, placePos)) continue;
            this.m_5974_((LevelWriter)level, placePos, crystal);
        }
        return true;
    }

    @Override
    public boolean isValidPos(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        return world.m_46859_(pos);
    }

    @Override
    public int getMaxHeight(Config config) {
        return config.radius;
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("crystal").forGetter(config -> config.cystal), (App)Codec.INT.fieldOf("tries").forGetter(config -> config.tries), (App)Codec.INT.fieldOf("radius").forGetter(config -> config.radius)).apply((Applicative)instance, Config::new));
        public final BlockState cystal;
        public final int tries;
        public final int radius;

        public Config(BlockState cystal, int tries, int radius) {
            this.cystal = cystal;
            this.tries = tries;
            this.radius = radius;
        }
    }
}

