/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class FrostbrightTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.frostbright_log.m_49966_();
    private static final BlockState LOG_X = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
    private static final BlockState LOG_Z = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
    private static final BlockState LEAF = SkiesBlocks.frostbright_leaves.m_49966_();
    private static final BlockState SNOW = Blocks.f_50125_.m_49966_();

    public FrostbrightTreeFeature(Codec<TreeConfiguration> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int z1;
        int x1;
        int z;
        int x;
        int height;
        int n = height = (double)rand.m_188503_(7) + Math.random() < 0.1 ? 30 : 20;
        if (!this.isAreaOk(world, pos, height, 2, height - 2, 11)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x2 = 0; x2 < 2; ++x2) {
                for (int z2 = 0; z2 < 2; ++z2) {
                    if (y >= height - 1 && (x2 != 0 || z2 != 0)) continue;
                    this.setBlockIfOk(changedLogs, world, pos.m_7918_(x2, y, z2), LOG);
                }
            }
        }
        for (x = -6; x <= 6; ++x) {
            for (z = -6; z <= 6; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.m_7918_(x > 0 ? x - 1 : x, height - 2, z > 0 ? z - 1 : z).m_7918_(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (!(z1 < 3 || z1 < 5 && x1 < 6 || z1 == 5 && x1 < 5) && (z1 != 6 || x1 >= 3)) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF);
                if (!this.natural) continue;
                this.setBlockIfOk(null, world, leafPos.m_7494_(), SNOW);
            }
        }
        for (x = -5; x <= 5; ++x) {
            for (z = -5; z <= 5; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.m_7918_(x > 0 ? x - 1 : x, height - 1, z > 0 ? z - 1 : z).m_7918_(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 >= 3 && (z1 >= 5 || x1 >= 5) && (z1 != 5 || x1 >= 3)) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF);
                if (!this.natural) continue;
                this.setBlockIfOk(null, world, leafPos.m_7494_(), SNOW);
            }
        }
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.m_7918_(x > 0 ? x - 1 : x, height, z > 0 ? z - 1 : z).m_7918_(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 + x1 > 4) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF);
                if (!this.natural || !world.m_46859_(leafPos.m_7494_())) continue;
                this.setBlockIfOk(null, world, leafPos.m_7494_(), SNOW);
            }
        }
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(rand.m_188503_(2), rand.m_188503_(height - 9) + 3, -1));
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(2, rand.m_188503_(height - 9) + 3, rand.m_188503_(2)));
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(rand.m_188503_(2), rand.m_188503_(height - 9) + 3, 2));
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(-1, rand.m_188503_(height - 9) + 3, rand.m_188503_(2)));
        for (int branch = 0; branch < 4; ++branch) {
            int l;
            int y = height - 5 - rand.m_188503_(2);
            int xz = rand.m_188503_(2);
            int length = rand.m_188503_(2) + 1;
            for (l = y; l < height - 2; ++l) {
                if (branch == 0) {
                    this.setBlockIfOk(changedLogs, world, pos.m_7918_(2 + length, l + 1, xz), LOG);
                }
                if (branch == 1) {
                    this.setBlockIfOk(changedLogs, world, pos.m_7918_(xz, l + 1, 2 + length), LOG);
                }
                if (branch == 2) {
                    this.setBlockIfOk(changedLogs, world, pos.m_7918_(-1 - length, l + 1, xz), LOG);
                }
                if (branch != 3) continue;
                this.setBlockIfOk(changedLogs, world, pos.m_7918_(xz, l + 1, -1 - length), LOG);
            }
            for (l = 0; l < length + 1; ++l) {
                if (branch == 0) {
                    this.setBlockIfOk(changedLogs, world, pos.m_7918_(2 + l, y, xz), LOG_X);
                }
                if (branch == 1) {
                    this.setBlockIfOk(changedLogs, world, pos.m_7918_(xz, y, 2 + l), LOG_Z);
                }
                if (branch == 2) {
                    this.setBlockIfOk(changedLogs, world, pos.m_7918_(-1 - l, y, xz), LOG_X);
                }
                if (branch != 3) continue;
                this.setBlockIfOk(changedLogs, world, pos.m_7918_(xz, y, -1 - l), LOG_Z);
            }
        }
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if (!((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                this.setBlockIfOk(changedLogs, world, pos.m_7918_(x, 0, z), LOG);
                this.setBlockIfOk(changedLogs, world, pos.m_7918_(x, 1, z), LOG);
                if (!rand.m_188499_()) continue;
                this.setBlockIfOk(changedLogs, world, pos.m_7918_(x, 2, z), LOG);
            }
        }
        if (this.natural) {
            this.placeSnowCircle(changedLogs, world, rand, pos);
        }
        return true;
    }

    protected void setLowerBranch(BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, BlockPos pos) {
        this.setBlockIfOk(changedLogs, world, pos, LOG);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 0; y < 2; ++y) {
                    if (y == 1 && Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, y, z), LEAF);
                }
            }
        }
    }

    protected void placeSnowCircle(BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel world, RandomSource rand, BlockPos centerPos) {
        for (int x = -5; x <= 6; ++x) {
            for (int z = -5; z <= 6; ++z) {
                BlockState snow;
                BlockPos offsetPos;
                if (!rand.m_188499_()) continue;
                for (int y = 2; y >= -3 && !this.setBlockIfOk(null, world, offsetPos = centerPos.m_7918_(x, y, z), snow = (BlockState)SNOW.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf((double)rand.m_188501_() > 0.8 ? 2 : 1))) && (world.m_46859_(offsetPos) || y >= 0); --y) {
                }
            }
        }
    }
}

