/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.construction.StarEmitterBlock;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.StringUtil;
import com.legacy.structure_gel.api.util.Positions;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AstrolabeItem
extends Item
implements Vanishable {
    public static final int MAX_DISTANCE = 300;

    public AstrolabeItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == this && player.m_7655_() == hand) {
            if (AstrolabeItem.getTeleportCooldown(stack) > 0) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.astrolabe_cooldown"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (SkiesPlayerEvents.inBossFight(player)) {
                player.m_5661_((Component)Component.m_237115_((String)"tile.keystone.leaving_in_fight"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            BlockPos teleportPos = AstrolabeItem.getTeleportPos(stack);
            if (teleportPos != null) {
                Optional<ResourceKey<Level>> teleportDim = AstrolabeItem.getTeleportDimension(stack);
                int distance = (int)EntityUtil.getDistanceToPos((Vec3i)player.m_20183_(), (Vec3i)teleportPos);
                if (distance > 300 || teleportDim.isPresent() && !teleportDim.get().m_135782_().equals((Object)player.m_9236_().m_46472_().m_135782_())) {
                    player.m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.astrolabe_too_far"), true);
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                player.m_6672_(hand);
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            player.m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.astrolabe_pos_not_set"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entityIn, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (i > 20) {
                BlockPos teleportPos = AstrolabeItem.getTeleportPos(stack);
                if (!world.f_46443_ && teleportPos != null) {
                    try {
                        Vec3 safeTeleportPos = StarEmitterBlock.findTeleportPoint(entityIn.m_6095_(), (CollisionGetter)world, teleportPos).orElse(Vec3.m_82528_((Vec3i)AstrolabeItem.getTeleportPos(stack)));
                        int distance = (int)EntityUtil.getDistanceToPos((Vec3i)player.m_20183_(), (Vec3i)Positions.blockPos((Position)safeTeleportPos));
                        if (world instanceof ServerLevel && !((ServerLevel)world).m_8904_().m_217874_(SkiesPoiTypes.STAR_EMITTER.getKey(), AstrolabeItem.getTeleportPos(stack))) {
                            player.m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.astrolabe_no_emitter"), true);
                            player.m_5810_();
                            return;
                        }
                        Optional<ResourceKey<Level>> teleportDim = AstrolabeItem.getTeleportDimension(stack);
                        if (distance > 300 || teleportDim.isPresent() && !teleportDim.get().m_135782_().equals((Object)player.m_9236_().m_46472_().m_135782_())) {
                            player.m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.astrolabe_too_far"), true);
                            player.m_5810_();
                            return;
                        }
                        if (player.m_20984_(safeTeleportPos.m_7096_(), safeTeleportPos.m_7098_(), safeTeleportPos.m_7094_(), true)) {
                            AstrolabeItem.setTeleportCooldown(stack, distance);
                            world.m_6263_((Player)null, safeTeleportPos.m_7096_(), safeTeleportPos.m_7098_(), safeTeleportPos.m_7094_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            player.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                            player.m_5810_();
                        }
                    }
                    catch (Exception e) {
                        BlueSkies.LOGGER.error((Object)e);
                    }
                    return;
                }
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (AstrolabeItem.getTeleportCooldown(stack) > 0 && entity.f_19797_ % 20 == 0) {
            AstrolabeItem.setTeleportCooldown(stack, AstrolabeItem.getTeleportCooldown(stack) - 1);
            Optional<ResourceKey<Level>> teleportDim = AstrolabeItem.getTeleportDimension(stack);
            if (AstrolabeItem.getTeleportCooldown(stack) == 0 && teleportDim.isPresent() && teleportDim.get().m_135782_().equals((Object)world.m_46472_().m_135782_())) {
                entity.m_9236_().m_6269_((Player)null, entity, SkiesSounds.ITEM_ASTROLABE_READY, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public static int getTeleportCooldown(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt == null ? 0 : compoundnbt.m_128451_("TeleportCooldown");
    }

    public static void setTeleportCooldown(ItemStack stack, int cooldownIn) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128405_("TeleportCooldown", cooldownIn);
    }

    @Nullable
    public static BlockPos getTeleportPos(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt == null ? null : NbtUtils.m_129239_((CompoundTag)compoundnbt.m_128469_("TeleportPosition"));
    }

    public static void setTeleportPos(ItemStack stack, BlockPos pos) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128365_("TeleportPosition", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public static Optional<ResourceKey<Level>> getTeleportDimension(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt == null ? Optional.empty() : Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundnbt.m_128423_("TeleportDimension")).result();
    }

    public static void setTeleportDimension(ItemStack stack, ResourceKey<Level> dimension) {
        CompoundTag compoundnbt = stack.m_41784_();
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, dimension).result().ifPresent(dim -> compoundnbt.m_128365_("TeleportDimension", dim));
    }

    public static boolean isWithinDistance(ItemStack stack, LivingEntity entity, Level world) {
        if (entity != null && entity.m_9236_() != null && stack != null) {
            BlockPos tpPos = AstrolabeItem.getTeleportPos(stack);
            Optional<ResourceKey<Level>> dimension = AstrolabeItem.getTeleportDimension(stack);
            if (tpPos != null && dimension.isPresent() && dimension.get().m_135782_().equals((Object)entity.m_9236_().m_46472_().m_135782_())) {
                return (int)EntityUtil.getDistanceToPos((Vec3i)entity.m_20183_(), (Vec3i)tpPos) < 300;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> lore, TooltipFlag flagIn) {
        lore.add((Component)Component.m_237115_((String)StringUtil.getAbilityText("gui.blue_skies.item.ability.teleportation")));
        if (AstrolabeItem.getTeleportCooldown(stack) > 0) {
            lore.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + "Teleport Cooldown: " + AstrolabeItem.getTeleportCooldown(stack))));
        }
    }
}

