/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class VenomBombEntity
extends ThrowableProjectile {
    public MobEffectInstance effect;
    public boolean lingering = false;

    public VenomBombEntity(EntityType<? extends VenomBombEntity> typeIn, Level worldIn) {
        super(typeIn, worldIn);
    }

    public VenomBombEntity(Level worldIn, LivingEntity livingEntityIn) {
        super(SkiesEntityTypes.VENOM_BOMB, livingEntityIn, worldIn);
    }

    public VenomBombEntity(Level worldIn, double x, double y, double z) {
        super(SkiesEntityTypes.VENOM_BOMB, x, y, z, worldIn);
    }

    public VenomBombEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.VENOM_BOMB, world);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                float dx = (this.f_19796_.m_188501_() - 0.5f) / 7.0f;
                float dy = this.f_19796_.m_188501_() / 10.0f;
                float dz = (this.f_19796_.m_188501_() - 0.5f) / 7.0f;
                this.m_9236_().m_7106_((ParticleOptions)new PoisonData(false), (double)this.m_20183_().m_123341_() + 0.5, (double)((float)this.m_20183_().m_123342_() + 0.5f), (double)this.m_20183_().m_123343_() + 0.5, (double)dx, (double)dy, (double)dz);
            }
        }
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult result) {
        BlockPos pos = this.m_20183_();
        RandomSource random = this.f_19796_;
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            if (!this.m_9236_().f_46443_) {
                this.applyEffectToNearbyMobs(this.effect, result.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)result).m_82443_() : null);
                if (this.lingering && random.m_188503_(3) == 0) {
                    this.makeAreaOfEffectCloud(this.effect);
                }
                this.m_146870_();
            } else {
                double d11 = (double)pos.m_123341_() + 0.5;
                double d14 = (double)pos.m_123342_() + 0.1;
                double d19 = (double)pos.m_123343_() + 0.5;
                for (int j2 = 0; j2 < 8; ++j2) {
                    this.m_9236_().m_7106_((ParticleOptions)new PoisonData(false), d11, d14, d19, random.m_188583_() * 0.15, random.m_188500_() * 0.2, random.m_188583_() * 0.15);
                }
            }
        }
    }

    private void applyEffectToNearbyMobs(MobEffectInstance effect, @Nullable Entity entityIn) {
        if (effect == null) {
            return;
        }
        AABB axisalignedbb = this.m_20191_().m_82377_(5.0, 2.0, 5.0);
        List list = this.m_9236_().m_45976_(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                int i;
                double d0;
                if (!livingentity.m_5801_() || !((d0 = this.m_20280_((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == entityIn) {
                    d1 = 1.0;
                }
                if ((i = (int)(d1 * (double)effect.m_19557_() + 0.5)) <= 20) continue;
                livingentity.m_7292_(new MobEffectInstance(effect.m_19544_(), i, effect.m_19564_(), effect.m_19571_(), effect.m_19572_()));
            }
        }
    }

    private void makeAreaOfEffectCloud(MobEffectInstance effect) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaeffectcloudentity.m_19712_(3.0f);
        areaeffectcloudentity.m_19732_(this.m_9236_().m_46791_() == Difficulty.EASY ? -5.0f : -3.0f);
        areaeffectcloudentity.m_19740_(20);
        areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
        if (this.m_19749_() instanceof LivingEntity) {
            areaeffectcloudentity.m_19718_((LivingEntity)this.m_19749_());
        }
        areaeffectcloudentity.m_19716_(effect);
        this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

