/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraftforge.common.util.Lazy;

public class SkyGrassBlock
extends GrassBlock {
    private final GrassProperties grassProp;

    public SkyGrassBlock(GrassProperties grassProp) {
        super(BlockBehaviour.Properties.m_284310_().m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56740_));
        this.grassProp = grassProp;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Block block = level.m_8055_(pos.m_7494_()).m_60734_();
        return (BlockState)state.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(block == Blocks.f_50125_ || block == Blocks.f_50127_));
    }

    private static boolean isLightAbove(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60734_() == Blocks.f_50125_ && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        int i = LightEngine.m_284282_((BlockGetter)level, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)level, blockpos));
        return i < level.m_7469_();
    }

    private static boolean isCovered(BlockState state, LevelReader level, BlockPos pos) {
        return SkyGrassBlock.isLightAbove(state, level, pos) && !level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.f_46443_) {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!SkyGrassBlock.isLightAbove(state, (LevelReader)level, pos)) {
                level.m_46597_(pos, this.grassProp.getDirtBlock());
            } else if (level.m_46803_(pos.m_7494_()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.m_7918_(rand.m_188503_(3) - 1, rand.m_188503_(5) - 3, rand.m_188503_(3) - 1);
                    Block dirt = level.m_8055_(blockpos).m_60734_();
                    BlockState spreadResult = this.grassProp.getSpreadResult(dirt);
                    if (spreadResult == null || !SkyGrassBlock.isCovered(this.m_49966_(), (LevelReader)level, blockpos)) continue;
                    level.m_46597_(blockpos, (BlockState)spreadResult.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(blockpos.m_7494_()).m_60734_() == Blocks.f_50125_)));
                }
            }
        }
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.m_7494_();
        BlockState grassState = this.grassProp.getTallGrass();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos placePos = abovePos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.m_8055_((placePos = placePos.m_7918_(rand.m_188503_(3) - 1, (rand.m_188503_(3) - 1) * rand.m_188503_(3) / 2, rand.m_188503_(3) - 1)).m_7495_()).m_60713_((Block)this) || level.m_8055_(placePos).m_60838_((BlockGetter)level, placePos)) continue block0;
            }
            BlockState blockAtPlace = level.m_8055_(placePos);
            if (blockAtPlace.m_60713_(grassState.m_60734_()) && rand.m_188503_(10) == 0) {
                ((BonemealableBlock)grassState.m_60734_()).m_214148_(level, rand, placePos, blockAtPlace);
            }
            if (!blockAtPlace.m_60795_()) continue;
            if (rand.m_188503_(8) == 0) {
                if (this.grassProp.flowerProvider == null) {
                    List flowerFeatures = ((Biome)level.m_204166_(placePos).m_203334_()).m_47536_().m_47815_();
                    if (flowerFeatures.isEmpty()) continue;
                    PlacedFeature placedFeature = (PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)flowerFeatures.get(rand.m_188503_(flowerFeatures.size()))).f_65378_()).f_191304_().m_203334_();
                    placedFeature.m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, placePos);
                    continue;
                }
                level.m_46597_(placePos, this.grassProp.flowerProvider.apply(rand).get().m_49966_());
                continue;
            }
            level.m_46597_(placePos, grassState);
        }
    }

    public static class GrassProperties {
        private final Lazy<BlockState> tallGrass = Lazy.of(() -> ((Block)grass.get()).m_49966_());
        private final Lazy<BlockState> dirtBlock = Lazy.of(() -> ((Block)dirtBlock.get()).m_49966_());
        private final Lazy<Map<Block, BlockState>> spreadMap = Lazy.of(() -> spreadMap.entrySet().stream().collect(Collectors.toMap(e -> (Block)((Supplier)e.getKey()).get(), e -> ((Block)((Supplier)e.getValue()).get()).m_49966_())));
        @Nullable
        public final Function<RandomSource, Supplier<Block>> flowerProvider;

        public GrassProperties(Supplier<Block> grass, Supplier<Block> dirtBlock, Map<Supplier<Block>, Supplier<Block>> spreadMap, @Nullable Function<RandomSource, Supplier<Block>> flowerProvider) {
            this.flowerProvider = flowerProvider;
        }

        public GrassProperties(Supplier<Block> grass, Supplier<Block> dirtBlock, Map<Supplier<Block>, Supplier<Block>> spreadMap) {
            this(grass, dirtBlock, spreadMap, null);
        }

        public BlockState getTallGrass() {
            return (BlockState)this.tallGrass.get();
        }

        public BlockState getDirtBlock() {
            return (BlockState)this.dirtBlock.get();
        }

        @Nullable
        public BlockState getSpreadResult(Block dirt) {
            return (BlockState)((Map)this.spreadMap.get()).get(dirt);
        }
    }
}

