/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Math;

public class InventoryUtil {
    public static Pair<ItemStack, Integer> findStack(IItemHandler source, Predicate<ItemStack> searchCriteria) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.getStackInSlot(i);
            if (!searchCriteria.test(stack)) continue;
            return Pair.of((Object)stack.m_41777_(), (Object)i);
        }
        return null;
    }

    public static void transferStacks(IItemHandlerModifiable source, IItemHandler target) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.getStackInSlot(i);
            source.setStackInSlot(i, InventoryUtil.addItem(target, stack));
        }
    }

    public static ItemStack addItem(IItemHandler target, ItemStack remaining) {
        int i;
        if (remaining.m_41619_()) {
            return remaining;
        }
        for (i = 0; i < target.getSlots(); ++i) {
            ItemStack stack = target.getStackInSlot(i);
            if (!stack.m_150930_(remaining.m_41720_())) continue;
            if (target.isItemValid(i, remaining)) {
                remaining = target.insertItem(i, remaining, false);
            }
            if (remaining.m_41619_()) break;
        }
        if (remaining.m_41619_()) {
            return remaining;
        }
        for (i = 0; i < target.getSlots(); ++i) {
            if (target.isItemValid(i, remaining)) {
                remaining = target.insertItem(i, remaining, false);
            }
            if (remaining.m_41619_()) break;
        }
        return remaining;
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min((int)inv.getSlotLimit(j), (int)itemstack.m_41741_());
            ++i;
        }
        return Mth.m_14143_((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    @Nullable
    public static ItemStack findStackWithItemFromHands(Player player, Item item) {
        if (item == null) {
            return null;
        }
        if (player == null) {
            return null;
        }
        ItemStack stack0 = player.m_21205_();
        ItemStack stack1 = player.m_21206_();
        if (stack0 != null && stack0.m_41720_() == item) {
            return stack0;
        }
        if (stack1 != null && stack1.m_41720_() == item) {
            return stack1;
        }
        return null;
    }

    public static int maxStackSizeWithContainer(Container container, int slot, ItemStack stack) {
        int stack_maxSize = stack.m_41741_();
        int container_maxSize = container.m_6893_();
        return Math.min((int)stack_maxSize, (int)container_maxSize);
    }

    public static int maxStackSizeWithContainer(ItemStackHandler container, int slot, ItemStack stack) {
        int stack_maxSize = stack.m_41741_();
        int container_maxSize = container.getSlotLimit(slot);
        return Math.min((int)stack_maxSize, (int)container_maxSize);
    }
}

