/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools.tool_actions;

import doggytalents.DoggyBlocks;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.tool_actions.ToolAction;
import doggytalents.common.util.RingSearchIterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DogFarmerAction
extends ToolAction {
    private static final int SEARCH_RADIUS = 4;
    private BlockPos nextFarmBlock;
    private int tickTillPathRecalc;
    private int tickTillResearch;
    private int checkAgainTimestamp;
    private ItemStack seedTarget = ItemStack.f_41583_;
    private ItemStack replacementStack = ItemStack.f_41583_;

    public DogFarmerAction(Dog dog, DoggyToolsTalent talent) {
        super(dog, talent);
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 3;
        this.tickTillResearch = 20;
    }

    @Override
    public void tick() {
        ItemStack hurtStack;
        FarmState farmState;
        ItemStack stack;
        boolean owner_check;
        boolean bl = owner_check = (Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_WANDER_FARM.get() == false || this.dog.getMode().shouldFollowOwner();
        if (owner_check) {
            LivingEntity owner = this.dog.m_269323_();
            if (owner == null || this.dog.m_20280_((Entity)owner) > (double)this.talent.getMaxOwnerDistSqr()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!owner.m_6084_() || owner.m_5833_()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }
        if ((stack = this.dog.m_21120_(InteractionHand.MAIN_HAND)) == null || !(stack.m_41720_() instanceof HoeItem)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.tickTillPathRecalc > 0) {
            --this.tickTillPathRecalc;
        }
        this.refreshTargetSeed();
        if (this.nextFarmBlock == null && --this.tickTillResearch <= 0) {
            this.tickTillResearch = 10;
            this.nextFarmBlock = this.findNextFarmBlock();
            if (this.nextFarmBlock == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }
        if ((farmState = this.getFarmState(this.nextFarmBlock)) == FarmState.NONE) {
            this.nextFarmBlock = null;
            return;
        }
        boolean hurtTools = this.moveToAndFarmBlock(farmState);
        if (hurtTools && this.dog.m_217043_().m_188503_(3) == 0 && (hurtStack = this.dog.m_21205_()) != null && hurtStack.m_41720_() instanceof HoeItem) {
            hurtStack.m_41622_(1, (LivingEntity)this.dog, p_150845_ -> p_150845_.m_21190_(InteractionHand.MAIN_HAND));
        }
    }

    private void refreshTargetSeed() {
        boolean isDogHarvestable;
        ItemStack stack;
        this.seedTarget = ItemStack.f_41583_;
        this.replacementStack = ItemStack.f_41583_;
        DoggyToolsItemHandler inv = this.talent.getTools();
        int harvest_slot_id = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            stack = inv.getStackInSlot(i);
            isDogHarvestable = this.getCropBlockFromItem(stack).isPresent();
            if (!isDogHarvestable) continue;
            this.seedTarget = stack.m_41777_();
            harvest_slot_id = i;
            break;
        }
        if (this.seedTarget.m_41619_()) {
            return;
        }
        int replace_slot_id = harvest_slot_id + 1;
        if (replace_slot_id < inv.getSlots() && (isDogHarvestable = this.getCropBlockFromItem(stack = inv.getStackInSlot(replace_slot_id)).isPresent()) && !stack.m_150930_(this.seedTarget.m_41720_())) {
            this.replacementStack = stack.m_41777_();
        }
    }

    private boolean moveToAndFarmBlock(FarmState farmState) {
        BlockPos dog_b0 = this.dog.m_20183_();
        PathNavigation dog_nav = this.dog.m_21573_();
        boolean shouldHurtTool = false;
        this.dog.m_21563_().m_24964_(Vec3.m_82539_((Vec3i)this.nextFarmBlock));
        if (dog_nav.m_26571_() && dog_b0.m_123331_((Vec3i)this.nextFarmBlock) <= 4.0) {
            this.dog.m_21566_().m_6849_((double)this.nextFarmBlock.m_123341_(), (double)this.nextFarmBlock.m_123342_(), (double)this.nextFarmBlock.m_123343_(), 1.0);
        }
        if (dog_b0.m_123331_((Vec3i)this.nextFarmBlock) < 4.0) {
            switch (farmState) {
                case HARVEST: {
                    this.harvest();
                    shouldHurtTool = true;
                    break;
                }
                case PLACE_SEED: {
                    this.placeSeed();
                    shouldHurtTool = true;
                    break;
                }
            }
            this.nextFarmBlock = null;
            return shouldHurtTool;
        }
        if (this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 20;
            dog_nav.m_26519_((double)this.nextFarmBlock.m_123341_(), (double)this.nextFarmBlock.m_123342_(), (double)this.nextFarmBlock.m_123343_(), 1.0);
        }
        return shouldHurtTool;
    }

    @Override
    public void onStop() {
        this.setState(TriggerableAction.ActionState.PENDING);
        this.nextFarmBlock = null;
        this.dog.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
    }

    @Override
    public boolean shouldUse(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!(stack.m_41720_() instanceof HoeItem)) {
            return false;
        }
        if (this.dog.f_19797_ < this.checkAgainTimestamp) {
            return false;
        }
        this.checkAgainTimestamp = this.dog.f_19797_ + 30;
        this.refreshTargetSeed();
        this.nextFarmBlock = this.findNextFarmBlock();
        return this.nextFarmBlock != null;
    }

    private BlockPos findNextFarmBlock() {
        BlockPos bp = this.dog.m_20183_();
        if (this.seedTarget == null || this.seedTarget.m_41619_()) {
            return null;
        }
        boolean owner_check = (Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_WANDER_FARM.get() == false || this.dog.getMode().shouldFollowOwner();
        LivingEntity owner = null;
        if (owner_check && (owner = this.dog.m_269323_()) == null) {
            return null;
        }
        for (BlockPos pos : RingSearchIterator.createWithRandom(bp, 4, 4, true, this.dog.m_217043_())) {
            if (owner != null && owner.m_20238_(Vec3.m_82539_((Vec3i)pos)) + 1.0 >= (double)this.talent.getMaxOwnerDistSqr() || this.getFarmState(pos) == FarmState.NONE) continue;
            return pos;
        }
        return null;
    }

    private void placeSeed() {
        BlockState wheatState = this.getCropBlockFromItem(this.replacementStack.m_41619_() ? this.seedTarget : this.replacementStack).orElse((CropBlock)DoggyBlocks.RICE_CROP.get()).m_49966_();
        this.dog.m_9236_().m_46597_(this.nextFarmBlock.m_7494_(), wheatState);
        SoundType soundtype = wheatState.getSoundType((LevelReader)this.dog.m_9236_(), this.nextFarmBlock.m_7494_(), (Entity)this.dog);
        this.dog.m_5496_(soundtype.m_56777_(), (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
    }

    private void harvest() {
        this.dog.m_9236_().m_46961_(this.nextFarmBlock.m_7494_(), true);
    }

    private FarmState getFarmState(BlockPos pos) {
        if (pos == null) {
            return FarmState.NONE;
        }
        if (this.seedTarget == null || this.seedTarget.m_41619_()) {
            return FarmState.NONE;
        }
        BlockState state = this.dog.m_9236_().m_8055_(pos);
        if (state.m_60734_() != Blocks.f_50093_) {
            return FarmState.NONE;
        }
        BlockState state_above = this.dog.m_9236_().m_8055_(pos.m_7494_());
        if (state_above.m_60734_() == Blocks.f_50016_) {
            return FarmState.PLACE_SEED;
        }
        Optional<CropBlock> crop_block_optional = this.getCropBlockFromItem(this.seedTarget);
        if (!crop_block_optional.isPresent()) {
            return FarmState.NONE;
        }
        CropBlock crop_block = crop_block_optional.get();
        if (state_above.m_60734_() == crop_block && crop_block.m_52307_(state_above)) {
            return FarmState.HARVEST;
        }
        return FarmState.NONE;
    }

    private Optional<CropBlock> getCropBlockFromItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem block_item = (BlockItem)item;
        Block block = block_item.m_40614_();
        if (!(block instanceof CropBlock)) {
            return Optional.empty();
        }
        CropBlock crop_block = (CropBlock)block;
        return Optional.of(crop_block);
    }

    private static enum FarmState {
        NONE,
        PLACE_SEED,
        HARVEST;

    }
}

