/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools.tool_actions;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.talent.doggy_tools.DogBridging;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.util.DogUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DogBridgingAction
extends TriggerableAction {
    private Phase phase = Phase.GO_TO_INITIAL_POS;
    private final DoggyToolsTalent toolsTalent;
    private final LivingEntity owner;
    private BlockPos initialPos;
    private Direction bridgingDir;
    private int bridgingY = 0;
    private BlockPos nextPos = null;
    private BlockPos prevPos = null;
    private int bridgeCooldown;

    public DogBridgingAction(Dog dog, LivingEntity owner, float bridgingRot, BlockPos initialPos, DoggyToolsTalent talent) {
        super(dog, false, false);
        this.owner = owner;
        this.toolsTalent = talent;
        this.initialPos = initialPos;
        this.bridgingDir = Direction.m_122364_((double)bridgingRot);
    }

    @Override
    public void onStart() {
        Path path = this.dog.m_21573_().m_7864_(this.initialPos, 1);
        if (path == null || !DogUtil.canPathReachTargetBlock(this.dog, path, this.initialPos, 1, this.dog.m_6056_())) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.phase = Phase.GO_TO_INITIAL_POS;
        this.dog.m_21573_().m_26536_(path, 1.0);
        PathNavigation pathNavigation = this.dog.m_21573_();
        if (pathNavigation instanceof DogPathNavigation) {
            DogPathNavigation dogNav = (DogPathNavigation)pathNavigation;
            dogNav.setDogMoveInTargetNode();
        }
        DogBridging.equipBridgingStack(this.toolsTalent, this.dog);
    }

    @Override
    public void tick() {
        if (!DogBridging.isValidBridgingDog(this.toolsTalent, this.dog)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.phase == Phase.GO_TO_INITIAL_POS) {
            this.goToInitialPos();
        } else {
            this.doBridge();
        }
    }

    private void goToInitialPos() {
        if (this.dog.m_21573_().m_26571_()) {
            this.phase = Phase.BRIDGE;
            this.nextPos = this.getNextPos();
            this.bridgingY = this.dog.m_20183_().m_123342_();
            return;
        }
    }

    private void doBridge() {
        NextPosAction next_pos_action;
        if (this.bridgeCooldown > 0) {
            --this.bridgeCooldown;
        }
        if (this.dog.m_20183_().m_123342_() != this.bridgingY) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.owner.m_6084_() || this.owner.m_5833_() || this.owner.m_20280_((Entity)this.dog) >= 144.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.nextPos == null) {
            this.nextPos = this.getNextPos();
        }
        if ((next_pos_action = this.getNextPosAction(this.nextPos)) == NextPosAction.STOP) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.m_21563_().m_24964_(Vec3.m_82539_((Vec3i)this.nextPos));
        if (next_pos_action == NextPosAction.GO) {
            GoState go_state = this.getGoState(this.nextPos);
            if (go_state == GoState.TOO_FAR) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (go_state == GoState.NOT_REACHED) {
                Vec3 go_pos = Vec3.m_82539_((Vec3i)this.nextPos);
                this.dog.m_21566_().m_6849_(go_pos.f_82479_, go_pos.f_82480_, go_pos.f_82481_, 0.5);
            } else {
                this.nextPos = null;
            }
        } else if (next_pos_action == NextPosAction.BRIDGE && this.bridgeCooldown <= 0 && !this.tryBridge(this.nextPos)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    private BlockPos getNextPos() {
        return this.dog.m_20183_().m_121945_(this.bridgingDir);
    }

    private NextPosAction getNextPosAction(BlockPos pos) {
        BlockPathTypes path_type = this.dog.getBlockPathTypeViaAlterations(pos);
        if (path_type == BlockPathTypes.OPEN) {
            return NextPosAction.BRIDGE;
        }
        if (path_type == BlockPathTypes.WALKABLE) {
            return NextPosAction.GO;
        }
        return NextPosAction.STOP;
    }

    private GoState getGoState(BlockPos pos) {
        float near_dist = 0.45f;
        float far_dist = 2.0f;
        double dist_sqr = this.dog.m_20238_(Vec3.m_82539_((Vec3i)pos));
        if (dist_sqr >= 4.0) {
            return GoState.TOO_FAR;
        }
        if (dist_sqr <= 0.20249998569488525) {
            return GoState.REACHED;
        }
        return GoState.NOT_REACHED;
    }

    private boolean tryBridge(BlockPos pos) {
        pos = pos.m_7495_();
        if (this.prevPos != null && this.prevPos.equals((Object)pos)) {
            return false;
        }
        BlockState state = this.dog.m_9236_().m_8055_(pos);
        if (!state.m_60795_()) {
            return false;
        }
        Optional<Pair<ItemStack, BlockItem>> pair_optional = DogBridging.getBridgingMaterial(this.toolsTalent, this.dog);
        if (!pair_optional.isPresent()) {
            return false;
        }
        Pair<ItemStack, BlockItem> pair = pair_optional.get();
        ((BlockItem)pair.getRight()).m_40576_(this.getBlockPlaceContext(pos, (ItemStack)pair.getLeft()));
        if (((ItemStack)pair.getLeft()).m_41619_()) {
            DogBridging.getBridgingMaterial(this.toolsTalent, this.dog).ifPresent(x -> this.dog.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)x.getLeft()));
        }
        this.bridgeCooldown = 15;
        this.prevPos = pos;
        return true;
    }

    private BlockPlaceContext getBlockPlaceContext(BlockPos place_pos, ItemStack stack) {
        return new BlockPlaceContext(this.dog.m_9236_(), null, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.m_82539_((Vec3i)place_pos), Direction.UP, place_pos, false));
    }

    @Override
    public void onStop() {
        if (this.isStarted()) {
            this.dog.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        DogBridging.onBridgingActionStop(this.owner);
    }

    @Override
    public void onDogGoesOfflineWhileActive() {
        DogBridging.onBridgingActionStop(this.owner);
    }

    private static enum Phase {
        GO_TO_INITIAL_POS,
        BRIDGE;

    }

    private static enum NextPosAction {
        GO,
        STOP,
        BRIDGE;

    }

    private static enum GoState {
        REACHED,
        NOT_REACHED,
        TOO_FAR;

    }
}

