/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTalents;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.ShootHandler;
import doggytalents.common.util.DogUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DoggyToolsRangedAttack
implements IDogRangedAttackManager {
    private Optional<DogThrownTrident> awaitingTrident = Optional.empty();
    private int delayedCrossbowAttack;

    @Override
    public boolean isApplicable(AbstractDog dog) {
        return DoggyToolsRangedAttack.getActiveShootHandler(dog) != ShootHandler.NONE;
    }

    @Override
    public boolean updateUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
        this.validateAwaitingTrident();
        ShootHandler handler = DoggyToolsRangedAttack.getActiveShootHandler(ctx.dog);
        return handler.updateUsingWeapon(this, ctx);
    }

    public void shootProjectile(AbstractDog dog, Projectile proj, LivingEntity target, SoundEvent shoot_sound) {
        double aim_y_offset_l_xz_influence = 0.2;
        double aim_y_offset_l_xz_influence_down = 0.1;
        double dx = target.m_20185_() - dog.m_20185_();
        double dz = target.m_20189_() - dog.m_20189_();
        double l_xz = Math.sqrt(dx * dx + dz * dz);
        double aim_y = target.m_20186_() + 0.5 * (double)target.m_20206_();
        double dy = aim_y - proj.m_20186_();
        dy = dy > 0.0 ? (dy += l_xz * 0.2) : (dy += l_xz * 0.1);
        double shoot_dir_x = dx;
        double shoot_dir_y = dy;
        double shoot_dir_z = dz;
        float power = 1.6f;
        float error_window = 2.0f;
        proj.m_6686_(shoot_dir_x, shoot_dir_y, shoot_dir_z, power, error_window);
        dog.m_5496_(shoot_sound, 1.0f, 1.0f / (dog.m_217043_().m_188501_() * 0.4f + 0.8f));
        dog.m_9236_().m_7967_((Entity)proj);
    }

    @Override
    public void onStop(AbstractDog dog) {
        dog.m_5810_();
        this.awaitingTrident = Optional.empty();
    }

    private void validateAwaitingTrident() {
        if (this.awaitingTrident == null) {
            return;
        }
        if (!this.awaitingTrident.isPresent()) {
            return;
        }
        DogThrownTrident trident = this.awaitingTrident.get();
        if (!trident.m_6084_()) {
            this.awaitingTrident = Optional.empty();
            return;
        }
    }

    public boolean hasAwaitingTrident() {
        return this.awaitingTrident != null && this.awaitingTrident.isPresent();
    }

    public void setAwaitingTrident(DogThrownTrident trident) {
        this.awaitingTrident = Optional.ofNullable(trident);
    }

    public void decDelayedCrossbowAttack() {
        if (this.delayedCrossbowAttack > 0) {
            --this.delayedCrossbowAttack;
        }
    }

    public void setDelayedCrossbowAttack(int x) {
        this.delayedCrossbowAttack = x;
    }

    public int getDelayedCrossbowAttack() {
        return this.delayedCrossbowAttack;
    }

    public static boolean isTridentAndEligible(ItemStack stack) {
        if (!DogUtil.isTrident(stack)) {
            return false;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_USE_TRIDENT.get()).booleanValue()) {
            return false;
        }
        return stack.getEnchantmentLevel(Enchantments.f_44955_) >= 2;
    }

    public static Optional<Pair<ItemStackHandler, Integer>> findArrowsInInventory(AbstractDog dog) {
        Optional talentInstOptional = dog.getTalent((Supplier)DoggyTalents.DOGGY_TOOLS);
        if (!talentInstOptional.isPresent()) {
            return Optional.empty();
        }
        Object t = talentInstOptional.get();
        if (!(t instanceof DoggyToolsTalent)) {
            return Optional.empty();
        }
        DoggyToolsTalent tools = (DoggyToolsTalent)t;
        ItemStackHandler inv = tools.getTools();
        int id = DoggyToolsRangedAttack.findArrowStackInInventory(inv);
        if (id >= 0) {
            return Optional.of(Pair.of((Object)inv, (Object)id));
        }
        talentInstOptional = dog.getTalent((Supplier)DoggyTalents.PACK_PUPPY);
        if (!talentInstOptional.isPresent()) {
            return Optional.empty();
        }
        Object t2 = talentInstOptional.get();
        if (!(t2 instanceof PackPuppyTalent)) {
            return Optional.empty();
        }
        PackPuppyTalent packPup = (PackPuppyTalent)t2;
        inv = packPup.inventory();
        id = DoggyToolsRangedAttack.findArrowStackInInventory(inv);
        if (id >= 0) {
            return Optional.of(Pair.of((Object)inv, (Object)id));
        }
        return Optional.empty();
    }

    private static int findArrowStackInInventory(ItemStackHandler inv) {
        if (inv == null) {
            return -1;
        }
        int selected_id = -1;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof ArrowItem)) continue;
            selected_id = i;
            break;
        }
        return selected_id;
    }

    public static boolean isInfinityBow(ItemStack bowStack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)bowStack) > 0;
    }

    public static ShootHandler getActiveShootHandler(AbstractDog dog) {
        ItemStack mainhand_item = dog.m_21205_();
        return DoggyToolsRangedAttack.getShootHandler(mainhand_item, dog);
    }

    public static ShootHandler getShootHandler(ItemStack stack, AbstractDog dog) {
        boolean eligible;
        if (stack.m_41619_()) {
            return ShootHandler.NONE;
        }
        if (stack.m_41720_() instanceof BowItem) {
            boolean bl = eligible = DoggyToolsRangedAttack.isInfinityBow(stack) || DoggyToolsRangedAttack.findArrowsInInventory(dog).isPresent();
            if (eligible) {
                return ShootHandler.BOW;
            }
        }
        if (stack.m_41720_() instanceof CrossbowItem && (eligible = DoggyToolsRangedAttack.findArrowsInInventory(dog).isPresent())) {
            return ShootHandler.CROSSBOW;
        }
        if (DoggyToolsRangedAttack.isTridentAndEligible(stack)) {
            return ShootHandler.TRIDENT;
        }
        return ShootHandler.NONE;
    }
}

