/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WaterHolderTalent
extends TalentInstance {
    private static int EFFECT_RANGE = 5;
    private static int SEARCH_RADIUS = 12;
    private int waterUnitLeft;
    private int ticktillSearch;
    private int tickTillRegenWater;
    private int tickScheduledForExtinguish = 0;
    private boolean scheduledExtinguish = false;

    public WaterHolderTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
    }

    private int getMaxWaterHold() {
        return 5 + this.level() * 3;
    }

    private float getOnFireTickFactor() {
        return 0.2f * (float)this.level();
    }

    private int decreaseTickOnFire(int tickOnFire) {
        if (tickOnFire <= 2) {
            return 0;
        }
        return Mth.m_14143_((float)((float)tickOnFire - this.getOnFireTickFactor() * (float)tickOnFire));
    }

    private int getWaterUnitleft() {
        return this.waterUnitLeft;
    }

    private void setWaterUnitLeft(int unit) {
        this.waterUnitLeft = Mth.m_14045_((int)unit, (int)0, (int)this.getMaxWaterHold());
    }

    private void incWaterUnitLeft() {
        this.setWaterUnitLeft(this.getWaterUnitleft() + 1);
    }

    private void decWaterUnitLeft() {
        this.setWaterUnitLeft(this.getWaterUnitleft() - 1);
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.m_9236_().f_46443_) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (dog.readyForNonTrivialAction() && !dog.getMode().shouldAttack() && dog.m_20096_() && --this.ticktillSearch <= 0) {
            this.ticktillSearch = 10;
            LivingEntity target = this.findOnFireTarget(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerExtinguishAction(dog, target);
            }
        }
        if (this.scheduledExtinguish && abstractDog.f_19797_ >= this.tickScheduledForExtinguish) {
            this.extinguishNearby(abstractDog);
            this.scheduledExtinguish = false;
        }
        if (abstractDog.m_20070_() && --this.tickTillRegenWater <= 0) {
            this.tickTillRegenWater = 10;
            this.incWaterUnitLeft();
        }
    }

    public void triggerExtinguishAction(Dog dog, LivingEntity target) {
        dog.triggerAction(new ExtinguishAction(dog, this, target));
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof BucketItem && !dog.m_9236_().f_46443_ && player.m_6144_()) {
            MutableComponent c1 = Component.m_237110_((String)"talent.doggytalents.water_holder.amount", (Object[])new Object[]{dog.m_7755_().getString()});
            c1.m_7220_((Component)Component.m_237113_((String)": "));
            if (this.level < this.talent.getMaxLevel()) {
                c1.m_7220_((Component)Component.m_237113_((String)("" + this.getWaterUnitleft())).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(239100)));
                c1.m_7220_((Component)Component.m_237113_((String)("/" + this.getMaxWaterHold())));
            } else {
                c1.m_7220_((Component)Component.m_237115_((String)"talent.doggytalents.water_holder.amount.unlim").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(239100)));
            }
            player.m_213846_((Component)c1);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42447_) {
            if (!dog.m_9236_().f_46443_) {
                if (this.getWaterUnitleft() >= this.getMaxWaterHold()) {
                    return InteractionResult.PASS;
                }
                this.setWaterUnitLeft(this.getMaxWaterHold());
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                dog.m_5496_(SoundEvents.f_11781_, dog.m_6121_(), 1.0f);
                Level level2 = dog.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, dog.m_20185_(), dog.m_20186_(), dog.m_20189_(), this.level * 8, (double)dog.m_20205_(), (double)0.8f, (double)dog.m_20205_(), 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void writeToNBT(AbstractDog dog, CompoundTag compound) {
        super.writeToNBT(dog, compound);
        compound.m_128405_("DTwaterUnitLeft", this.getWaterUnitleft());
    }

    @Override
    public void readFromNBT(AbstractDog dog, CompoundTag compound) {
        super.readFromNBT(dog, compound);
        this.setWaterUnitLeft(compound.m_128451_("DTwaterUnitLeft"));
    }

    private void extinguishNearby(AbstractDog dog) {
        List<LivingEntity> targets = this.getNearbyOnFire(dog);
        if (targets.isEmpty()) {
            return;
        }
        this.decWaterUnitLeft();
        for (LivingEntity e : targets) {
            this.extinguishEntity(dog, e);
        }
    }

    private void extinguishEntity(AbstractDog dog, LivingEntity e) {
        int a0 = e.m_20094_();
        e.m_7311_(this.decreaseTickOnFire(a0));
        e.m_5496_(SoundEvents.f_11937_, 0.5f, 2.6f + e.m_217043_().m_188501_() - e.m_217043_().m_188501_() * 0.8f);
        Level level = dog.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, e.m_20185_(), e.m_20186_(), e.m_20189_(), 15, (double)e.m_20205_(), (double)0.8f, (double)e.m_20205_(), 0.1);
        }
        BlockPos e_b0 = e.m_20183_();
        BlockPos.MutableBlockPos e_b0m = e_b0.m_122032_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                e_b0m.m_142451_(e_b0.m_123341_() + i);
                e_b0m.m_142443_(e_b0.m_123343_() + j);
                if (e.m_9236_().m_8055_((BlockPos)e_b0m).m_60734_() != Blocks.f_50083_) continue;
                e.m_9236_().m_46597_((BlockPos)e_b0m, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public void scheduleDelayedExtinguish(AbstractDog dog) {
        if (this.scheduledExtinguish) {
            return;
        }
        this.scheduledExtinguish = true;
        this.tickScheduledForExtinguish = dog.f_19797_ + this.getDelay();
    }

    private List<LivingEntity> getNearbyOnFire(AbstractDog dog) {
        LivingEntity owner = dog.m_269323_();
        if (owner == null) {
            return List.of();
        }
        return dog.m_9236_().m_6443_(LivingEntity.class, dog.m_20191_().m_82377_((double)EFFECT_RANGE, 4.0, (double)EFFECT_RANGE), e -> {
            if (!e.m_6060_()) return false;
            if (!(owner == e || e instanceof AbstractDog && ((AbstractDog)e).m_269323_() == owner || e instanceof Wolf && ((Wolf)e).m_269323_() == owner)) {
                if (!(e instanceof Player)) return false;
                Player p = (Player)e;
                if (!(dog instanceof Dog)) return false;
                Dog d = (Dog)dog;
                if (!d.regardTeamPlayers()) return false;
                if (!p.m_7307_((Entity)owner)) return false;
            }
            if (!dog.m_21574_().m_148306_((Entity)e)) return false;
            return true;
        });
    }

    private LivingEntity findOnFireTarget(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        Predicate<LivingEntity> onFireAndWitness = e -> e.m_6060_() && e.m_20096_() && dog.m_21574_().m_148306_((Entity)e);
        LivingEntity owner = dog.m_269323_();
        if (owner == null) {
            return null;
        }
        if (onFireAndWitness.test(owner)) {
            targets.add(owner);
        }
        if (!(dogs = dog.m_9236_().m_6443_(AbstractDog.class, dog.m_20191_().m_82377_((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), d -> d.m_269323_() == owner && onFireAndWitness.test((LivingEntity)d))).isEmpty()) {
            targets.addAll(dogs);
        }
        if (!(wolves = dog.m_9236_().m_6443_(Wolf.class, dog.m_20191_().m_82377_((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), w -> w.m_269323_() == owner && onFireAndWitness.test((LivingEntity)w))).isEmpty()) {
            targets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.m_9236_().m_6443_(Player.class, dog.m_20191_().m_82377_((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), p -> p.m_7307_((Entity)owner) && onFireAndWitness.test((LivingEntity)p))).isEmpty()) {
            targets.addAll(teamPlayers);
        }
        return this.selectOnFireTarget(dog, targets);
    }

    private LivingEntity selectOnFireTarget(AbstractDog dog, List<LivingEntity> targets) {
        if (targets.isEmpty()) {
            return null;
        }
        LivingEntity target = targets.get(0);
        double mindistanceSqr = target.m_20280_((Entity)dog);
        LivingEntity owner = dog.m_269323_();
        for (LivingEntity i : targets) {
            if (owner == i) {
                return i;
            }
            double d = i.m_20280_((Entity)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    public int getDelay() {
        return 10;
    }

    private boolean canAffordToExtinguish(AbstractDog dog) {
        return this.getWaterUnitleft() > 0 || this.level() >= this.talent.getMaxLevel();
    }

    private boolean stillValidTarget(Dog dog, LivingEntity target) {
        if (!target.m_6084_()) {
            return false;
        }
        if (target.m_20094_() < 30) {
            return false;
        }
        if (!this.canAffordToExtinguish(dog)) {
            return false;
        }
        if (target.m_20077_()) {
            return false;
        }
        return !(dog.m_20280_((Entity)target) > 400.0);
    }

    public static class ExtinguishAction
    extends TriggerableAction {
        private WaterHolderTalent talentInst;
        private @NonNull LivingEntity target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public ExtinguishAction(Dog dog, WaterHolderTalent talentInst, @NonNull LivingEntity target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public boolean shouldStopAndFollowOwner() {
            return true;
        }

        @Override
        public float getDistanceForFollowOwner() {
            return 20.0f;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public void tick() {
            if (this.dog.getMode().shouldAttack()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.m_20280_((Entity)this.target) > 4.0) {
                this.dog.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.dog.m_8132_());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_5624_((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.m_21573_().m_26573_();
                if (this.dog.canDogDoShakeAnim()) {
                    this.dog.startShakingAndBroadcast(false);
                    this.talentInst.scheduleDelayedExtinguish(this.dog);
                }
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }
    }
}

