/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class FireDrillTalent
extends TalentInstance {
    private int rollCooldown = 0;
    private boolean fireExtinguished = false;
    private boolean isInFire = false;
    private boolean isRolling = false;
    private int tickTillUpdateInFire = 10;

    public FireDrillTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void livingTick(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (this.rollCooldown > 0) {
            --this.rollCooldown;
        }
        if (dog.m_20094_() >= 20 || this.isRolling) {
            this.updateInFire(dog);
            if (this.canRoll(dog)) {
                dog.triggerAction(new DogStopDropRollAction(dog, this));
                this.rollCooldown = 40;
            }
        }
    }

    private void updateInFire(Dog dog) {
        if (--this.tickTillUpdateInFire > 0) {
            return;
        }
        this.tickTillUpdateInFire = 10;
        this.isInFire = true;
        AABB bb = dog.m_20191_();
        BlockPos startPos = BlockPos.m_274561_((double)bb.f_82288_, (double)bb.f_82289_, (double)bb.f_82290_);
        BlockPos endPos = BlockPos.m_274561_((double)bb.f_82291_, (double)bb.f_82292_, (double)bb.f_82293_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos)) {
            BlockState state = dog.m_9236_().m_8055_(pos);
            if (!(state.m_60734_() instanceof FireBlock)) continue;
            return;
        }
        this.isInFire = false;
    }

    private boolean canRoll(Dog dog) {
        if (this.rollCooldown > 0) {
            return false;
        }
        if (this.isInFire) {
            return false;
        }
        if (!dog.m_20096_()) {
            return false;
        }
        if (dog.m_21825_()) {
            return false;
        }
        if (!dog.canDoIdileAnim()) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return dog.m_5448_() == null;
    }

    private boolean canContinueToRoll(Dog dog) {
        if (this.isInFire) {
            return false;
        }
        if (!dog.m_20096_()) {
            return false;
        }
        if (dog.m_21825_()) {
            return false;
        }
        if (!dog.canContinueDoIdileAnim()) {
            return false;
        }
        return !this.fireExtinguished || !dog.m_6060_();
    }

    @Override
    public InteractionResult stillIdleOrSitWhenHurt(AbstractDog dog, DamageSource source, float amount) {
        if (this.isRolling && source.m_276093_(DamageTypes.f_268468_)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static class DogStopDropRollAction
    extends TriggerableAction {
        private int stopTick;
        private int tickTillExtinguish = 60;
        private FireDrillTalent talentInst;

        public DogStopDropRollAction(Dog dog, FireDrillTalent talentInst) {
            super(dog, false, false);
            this.talentInst = talentInst;
        }

        @Override
        public void onStart() {
            this.stopTick = this.dog.f_19797_ + DogAnimation.STOP_DROP_ROLL.getLengthTicks();
            this.dog.setAnimForIdle(DogAnimation.STOP_DROP_ROLL);
            this.talentInst.fireExtinguished = false;
            this.talentInst.isRolling = true;
        }

        @Override
        public void tick() {
            if (this.dog.getAnim() != DogAnimation.STOP_DROP_ROLL) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.f_19797_ >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.canContinueToRoll(this.dog)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            --this.tickTillExtinguish;
            if (this.tickTillExtinguish == 0 && this.dog.m_6060_()) {
                this.dog.m_20095_();
                this.dog.m_5496_(SoundEvents.f_11937_, 0.5f, 2.6f + this.dog.m_217043_().m_188501_() - this.dog.m_217043_().m_188501_() * 0.8f);
                this.talentInst.fireExtinguished = true;
            }
        }

        @Override
        public void onStop() {
            if (this.dog.getAnim() == DogAnimation.STOP_DROP_ROLL) {
                this.dog.setAnim(DogAnimation.NONE);
            }
            this.talentInst.rollCooldown = 40;
            this.talentInst.isRolling = false;
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }

        @Override
        public boolean canPreventSit() {
            return true;
        }
    }
}

