/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.InventoryUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DoggyTorchTalent
extends TalentInstance {
    private boolean placingTorch = true;
    private boolean renderTorch = true;

    public DoggyTorchTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (this.placingTorch && dogIn.f_19797_ % 10 == 0 && dogIn.m_21824_()) {
            BlockPos pos = dogIn.m_20183_();
            BlockState torchState = Blocks.f_50081_.m_49966_();
            if (dogIn.m_9236_().m_46803_(dogIn.m_20183_()) < 8 && dogIn.m_9236_().m_46859_(pos) && torchState.m_60710_((LevelReader)dogIn.m_9236_(), pos)) {
                Pair<ItemStack, Integer> foundDetails;
                PackPuppyItemHandler inventory = dogIn.getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null);
                if (this.level() >= 5) {
                    dogIn.m_9236_().m_46597_(pos, torchState);
                } else if (inventory != null && (foundDetails = InventoryUtil.findStack((IItemHandler)inventory, stack -> stack.m_41720_() == Items.f_42000_)) != null && !((ItemStack)foundDetails.getLeft()).m_41619_()) {
                    ItemStack torchStack = (ItemStack)foundDetails.getLeft();
                    dogIn.consumeItemFromStack((Entity)dogIn, torchStack);
                    inventory.setStackInSlot((Integer)foundDetails.getRight(), torchStack);
                    dogIn.m_9236_().m_46597_(pos, torchState);
                }
            }
        }
    }

    public boolean canRenderTorch() {
        return this.level() >= 5;
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.placingTorch = compound.m_128471_("placingTorch");
        this.renderTorch = compound.m_128471_("renderTorch");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128379_("placingTorch", this.placingTorch);
        compound.m_128379_("renderTorch", this.renderTorch);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.DOGGY_TORCH_ENABLE.get()) {
            return this.placingTorch;
        }
        if (entry == TalentsOptions.DOGGY_TORCH_RENDER.get()) {
            return this.renderTorch;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.DOGGY_TORCH_ENABLE.get()) {
            this.placingTorch = (Boolean)data;
        }
        if (entry == TalentsOptions.DOGGY_TORCH_RENDER.get()) {
            this.renderTorch = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.DOGGY_TORCH_ENABLE.get(), TalentsOptions.DOGGY_TORCH_RENDER.get());
    }

    public boolean placingTorch() {
        return this.placingTorch;
    }

    public void setPlacingTorch(boolean torch) {
        this.placingTorch = torch;
    }

    public boolean renderTorch() {
        return this.renderTorch;
    }

    public void setRenderTorch(boolean torch) {
        this.renderTorch = torch;
    }
}

