/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.DogLevel;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.RandomUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TreatItem
extends Item
implements IDogItem {
    private final int maxLevel;
    private final DogLevel.Type type;

    public TreatItem(int maxLevel, DogLevel.Type typeIn, Item.Properties properties) {
        super(properties);
        this.maxLevel = maxLevel;
        this.type = typeIn;
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!dog.m_21824_() || !dog.canInteract((LivingEntity)playerIn)) {
            return InteractionResult.FAIL;
        }
        if (this.handleKamiBypass(dog, worldIn, playerIn, handIn).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        return this.handleTreatTrain(dog, worldIn, playerIn, handIn);
    }

    private InteractionResult handleKamiBypass(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (this.type != DogLevel.Type.KAMI) {
            return InteractionResult.PASS;
        }
        if (!playerIn.m_7500_()) {
            return InteractionResult.PASS;
        }
        DogLevel dog_level = dog.getDogLevel();
        if (dog_level.canIncrease(DogLevel.Type.KAMI)) {
            return InteractionResult.PASS;
        }
        if (!(dog instanceof Dog)) {
            return InteractionResult.PASS;
        }
        Dog actual_dog = (Dog)dog;
        if (!dog.m_9236_().f_46443_) {
            actual_dog.setLevel(DogLevel.kamiReady());
            playerIn.m_36335_().m_41524_((Item)this, 40);
        }
        this.playKamiBypassEffect(actual_dog);
        return InteractionResult.SUCCESS;
    }

    private void playKamiBypassEffect(Dog dog) {
        Level level = dog.m_9236_();
        if (!level.f_46443_) {
            return;
        }
        Vec3 dog_pos = dog.m_20182_();
        level.m_7785_(dog_pos.f_82479_, dog_pos.f_82480_, dog_pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, dog_pos.f_82479_, dog_pos.f_82480_, dog_pos.f_82481_, 1.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, dog_pos.f_82479_, dog_pos.f_82480_, dog_pos.f_82481_, 1.0, 0.0, 0.0);
        for (int i = 0; i <= 30; ++i) {
            float f1 = RandomUtil.nextFloatRemapped(dog.m_217043_()) * dog.m_20205_() * 1.0f;
            float f2 = RandomUtil.nextFloatRemapped(dog.m_217043_()) * dog.m_20205_() * 1.0f;
            double dx = level.m_213780_().m_188583_() * 0.3;
            double dy = level.m_213780_().m_188583_() * 0.3;
            double dz = level.m_213780_().m_188583_() * 0.3;
            dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, dog.m_20185_() + (double)f1, dog.m_20186_(), dog.m_20189_() + (double)f2, dx, dy, dz);
        }
    }

    private InteractionResult handleTreatTrain(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (dog.m_146764_() < 0) {
            this.treatFailPrompt(dog, worldIn, playerIn, (Component)Component.m_237115_((String)("treat." + this.type.getName() + ".too_young")));
            return InteractionResult.CONSUME;
        }
        DogLevel dogLevel = dog.getDogLevel();
        if (!dogLevel.canIncrease(this.type)) {
            this.treatFailPrompt(dog, worldIn, playerIn, (Component)Component.m_237115_((String)("treat." + this.type.getName() + ".low_level")));
            return InteractionResult.CONSUME;
        }
        if (dogLevel.getLevel(this.type) >= this.maxLevel) {
            this.treatFailPrompt(dog, worldIn, playerIn, (Component)Component.m_237115_((String)("treat." + this.type.getName() + ".max_level")));
            return InteractionResult.CONSUME;
        }
        if (!playerIn.m_9236_().f_46443_) {
            if (!playerIn.m_150110_().f_35937_) {
                playerIn.m_21120_(handIn).m_41774_(1);
            }
            dog.increaseLevel(this.type);
            dog.m_21839_(true);
        }
        this.treatSuccessPrompt(dog, worldIn, playerIn);
        return InteractionResult.SUCCESS;
    }

    private void treatFailPrompt(AbstractDog dog, Level worldIn, Player playerIn, Component msg) {
        if (!worldIn.f_46443_) {
            worldIn.m_7605_((Entity)dog, (byte)6);
            playerIn.m_213846_(msg);
        }
    }

    private void treatSuccessPrompt(AbstractDog dog, Level worldIn, Player playerIn) {
        if (!worldIn.f_46443_) {
            worldIn.m_7605_((Entity)dog, (byte)7);
            playerIn.m_213846_((Component)Component.m_237115_((String)("treat." + this.type.getName() + ".level_up")));
        }
    }
}

