/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyAdvancementTriggers;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.DogEddibleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SakeItem
extends DogEddibleItem {
    public SakeItem(Item.Properties itemProps) {
        super(itemProps, b -> b.m_41487_(8).m_41495_(Items.f_42590_), b -> b.m_38765_());
    }

    @Override
    public boolean canConsume(AbstractDog dog, ItemStack stackIn, @Nullable Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (!(entityIn instanceof Player)) {
            return false;
        }
        Player player = (Player)entityIn;
        if (player.m_36335_().m_41519_((Item)this)) {
            return false;
        }
        if (dog.m_269323_() != player) {
            return false;
        }
        return !dog.m_6162_() && super.canConsume(dog, stackIn, entityIn);
    }

    @Override
    public InteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        InteractionResult ret = super.consume(dog, stack, entityIn);
        this.mayBoostOrDrunkEntity((LivingEntity)dog, entityIn);
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.m_36335_().m_41524_((Item)this, 40);
        }
        return ret;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack ret = stack;
        if (!(entity instanceof Player)) {
            return ret;
        }
        Player player = (Player)entity;
        if (!player.m_9236_().f_46443_) {
            this.mayBoostOrDrunkEntity((LivingEntity)player, null);
            player.m_36335_().m_41524_((Item)this, 40);
        }
        if (!player.m_150110_().f_35937_) {
            ret.m_41774_(1);
        }
        if (ret.m_41619_()) {
            return new ItemStack((ItemLike)Items.f_42590_);
        }
        ItemStack bonusReturnStack = new ItemStack((ItemLike)Items.f_42590_);
        Inventory inv = player.m_150109_();
        int freeSlot = inv.m_36062_();
        if (freeSlot >= 0) {
            inv.m_36054_(bonusReturnStack);
        } else {
            player.m_19983_(bonusReturnStack);
        }
        return ret;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_42993_, Player p_42994_, InteractionHand p_42995_) {
        return ItemUtils.m_150959_((Level)p_42993_, (Player)p_42994_, (InteractionHand)p_42995_);
    }

    public boolean m_41472_() {
        return false;
    }

    @Override
    public SoundEvent getDogEatingSound(AbstractDog dog) {
        return SoundEvents.f_11911_;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack p_41454_) {
        return 32;
    }

    @Override
    public boolean alwaysEatWhenDogConsume(AbstractDog dog) {
        return true;
    }

    @Override
    public ItemStack getReturnStackAfterDogConsume(ItemStack useStack, AbstractDog dog) {
        return new ItemStack((ItemLike)Items.f_42590_);
    }

    private void mayBoostOrDrunkEntity(LivingEntity entity, @Nullable Entity feeder) {
        boolean drunk;
        float r = entity.m_217043_().m_188501_();
        boolean bl = drunk = r <= 0.4f;
        if (!drunk) {
            if (!(entity instanceof Dog) && !(entity instanceof Player)) {
                return;
            }
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 2));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 1200, 0));
            return;
        }
        int r_drunkTicks = 20 * (30 + entity.m_217043_().m_188503_(15));
        if (entity instanceof Dog) {
            Dog dog = (Dog)entity;
            if (feeder instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)feeder;
                DoggyAdvancementTriggers.DOG_DRUNK_TRIGGER.trigger(dog, sP);
            }
            dog.setDrunkTicks(r_drunkTicks);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            r_drunkTicks = 1200;
            if (player.m_217043_().m_188499_()) {
                r_drunkTicks *= 2;
            }
            player.m_21195_(MobEffects.f_19596_);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, r_drunkTicks, 2));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, r_drunkTicks, 3));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, r_drunkTicks, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, r_drunkTicks, 3));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        String desc_id = this.m_5671_(stack) + ".description";
        components.add((Component)Component.m_237115_((String)desc_id).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
    }
}

