/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.recipe;

import doggytalents.DoggyRecipeSerializers;
import doggytalents.common.item.DoubleDyableAccessoryItem;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DoubleDyableRecipe
extends CustomRecipe {
    public DoubleDyableRecipe(ResourceLocation p_252125_, CraftingBookCategory p_249010_) {
        super(p_252125_, p_249010_);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack paperStack = null;
        ItemStack dyeStack = null;
        ItemStack targetStack = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42516_)) {
                if (paperStack != null) {
                    return false;
                }
                paperStack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof DoubleDyableAccessoryItem) {
                if (targetStack != null) {
                    return false;
                }
                targetStack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof DyeItem) {
                if (dyeStack != null) continue;
                dyeStack = stack;
                continue;
            }
            return false;
        }
        return dyeStack != null && targetStack != null;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack paperStack = null;
        ArrayList<DyeColor> dyeList = new ArrayList<DyeColor>();
        ItemStack targetStack = null;
        boolean fg_color = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42516_)) {
                if (paperStack != null) {
                    return ItemStack.f_41583_;
                }
                paperStack = stack;
                fg_color = true;
                continue;
            }
            if (stack.m_41720_() instanceof DoubleDyableAccessoryItem) {
                if (targetStack != null) {
                    return ItemStack.f_41583_;
                }
                targetStack = stack;
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)item;
            dyeList.add(dye.m_41089_());
        }
        if (targetStack == null || dyeList.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return DoubleDyableAccessoryItem.copyAndSetColorForStack(targetStack, dyeList, fg_color);
    }

    public boolean m_8004_(int p_43759_, int p_43760_) {
        return p_43759_ * p_43760_ >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DoggyRecipeSerializers.DOUBLE_DYABLE.get();
    }
}

