/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.event;

import doggytalents.common.forward_imitate.DatapackUtil_1_20_under;
import doggytalents.common.lib.Resources;
import doggytalents.common.util.Util;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class PackHandler {
    public static final String BUILTIN_PREFIX = "mod/" + Util.getResource("builtin");
    public static final String ALT_RECIPE_1 = "alt_recipe_1";

    public static void onAddPackFinder(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource(PackHandler::onRegisterServerPack);
        }
    }

    private static void onRegisterServerPack(Consumer<Pack> pack_consumer) {
        PackHandler.findAndCreatePack(PackType.SERVER_DATA, ALT_RECIPE_1, (Component)Component.m_237113_((String)"DTN Recipe Pack I."), PackSource.f_244201_, false, Pack.Position.TOP).ifPresent(pack_consumer::accept);
    }

    public static String getBuiltinPackLocationNamespace(String id) {
        return "data/doggytalents/datapacks/" + id;
    }

    public static Optional<ResourceLocation> onPackLoadIcon(Pack pack) {
        String pack_id = pack.m_10446_();
        if (PackHandler.isBuiltinPack(pack_id)) {
            return Optional.of(Resources.DTN_PACK_ICON);
        }
        return Optional.empty();
    }

    private static Optional<Pack> findAndCreatePack(PackType type, String id, Component display_name, PackSource source, boolean always_active, Pack.Position position) {
        String mod_path = PackHandler.getBuiltinPackLocationNamespace(id);
        IModInfo mod_info = ((ModContainer)ModList.get().getModContainerById("doggytalents").orElseThrow()).getModInfo();
        String version = mod_info.getVersion().toString();
        Path res_path = mod_info.getOwningFile().getFile().findResource(new String[]{mod_path});
        DatapackUtil_1_20_under.KnownPack known_pack_info = new DatapackUtil_1_20_under.KnownPack("doggytalents", id, version);
        DatapackUtil_1_20_under.PackLocationInfo pack_location_info = new DatapackUtil_1_20_under.PackLocationInfo(BUILTIN_PREFIX + "/" + id, display_name, source, Optional.of(known_pack_info));
        Pack pack = DatapackUtil_1_20_under.readMetaAndCreate(pack_location_info, DatapackUtil_1_20_under.BuiltInPackSource.fromName(pack_info -> new PathPackResources(pack_info, res_path, true)), type, new DatapackUtil_1_20_under.PackSelectionConfig(always_active, position, false));
        return Optional.ofNullable(pack);
    }

    public static boolean isBuiltinPack(String id) {
        return id != null && id.startsWith(BUILTIN_PREFIX);
    }
}

