/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyItems;
import doggytalents.common.entity.misc.BaseDogPlushie;
import doggytalents.common.item.DogPlushieItem;
import doggytalents.common.util.NetworkUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class DogPlushie
extends BaseDogPlushie
implements IEntityAdditionalSpawnData {
    private int collarCollor = 11546150;
    private DogVariant variant = DogVariantUtil.getDefault();
    private boolean collarThicc = false;

    public DogPlushie(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void setCollarColor(int val) {
        this.collarCollor = val;
    }

    public int getCollarColor() {
        return this.collarCollor;
    }

    public void setDogVariant(DogVariant variant) {
        this.variant = variant;
    }

    public DogVariant getDogVariant() {
        return this.variant;
    }

    public void setCollarThicc(boolean val) {
        this.collarThicc = val;
    }

    public boolean getCollarThicc() {
        return this.collarThicc;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("PlushCollarColor", 3)) {
            this.setCollarColor(compound.m_128451_("PlushCollarColor"));
        }
        if (compound.m_128425_("classicalVariant", 8)) {
            this.setDogVariant(DogVariantUtil.fromSaveString(compound.m_128461_("classicalVariant")));
        }
        this.setCollarThicc(compound.m_128471_("collarThicc"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("PlushCollarColor", this.getCollarColor());
        compound.m_128359_("classicalVariant", DogVariantUtil.toSaveString(this.getDogVariant()));
        compound.m_128379_("collarThicc", this.getCollarThicc());
    }

    @Override
    public ItemStack getDogPlusieItemDrop() {
        DogPlushieItem item = DoggyItems.DOG_PLUSHIE_TOY.get();
        ItemStack stack = new ItemStack((ItemLike)item);
        item.m_41115_(stack, this.getCollarColor());
        return stack;
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeInt(this.getCollarColor());
        NetworkUtil.writeDogVariantToBuf(buf, this.variant);
        buf.writeBoolean(this.getCollarThicc());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        int collar_color = buf.readInt();
        DogVariant variant = NetworkUtil.readDogVariantFromBuf(buf);
        boolean thicc = buf.readBoolean();
        this.setCollarColor(collar_color);
        this.setDogVariant(variant);
        this.setCollarThicc(thicc);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

