/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class DogPlayTagAction
extends TriggerableAction {
    private boolean ownerBeenTagged = false;
    private static final int RUN_AWAY_RADIUS = 20;
    private static final int RUN_AWAY_RADIUS_MIN = 16;
    private static final int RUN_AWAY_PATH_INTERVAL = 10;
    private static final int RUN_AWAY_LOOKBACK_INTERVAL = 20;
    private static final int RUN_AWAY_LOOKBACK_TIME = 20;
    private static final int TIME_LIMIT_PER_TURN = 400;
    private int tickTillPathRecalc;
    private int cooldownChase;
    private int timeLeft;
    private int tickTillLook;
    private LivingEntity owner;

    public DogPlayTagAction(Dog dog, LivingEntity owner) {
        super(dog, true, true);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.timeLeft = 400;
        this.cooldownChase = 10;
    }

    @Override
    public void tick() {
        if (!this.owner.m_6084_() || this.owner.m_5833_()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        --this.timeLeft;
        if (this.dog.m_20280_((Entity)this.owner) > 400.0 || this.timeLeft <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            if (this.ownerBeenTagged) {
                this.owner.m_213846_((Component)Component.m_237110_((String)"dog.msg.play_tag.dog_win", (Object[])new Object[]{this.dog.m_7755_().getString()}));
                this.dog.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1));
            } else {
                this.owner.m_213846_((Component)Component.m_237110_((String)"dog.msg.play_tag.you_win", (Object[])new Object[]{this.dog.m_7755_().getString()}));
                this.owner.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1));
            }
            return;
        }
        if (!this.ownerBeenTagged) {
            if (this.cooldownChase <= 0) {
                this.chaseOwner(this.dog, this.owner);
            } else {
                --this.cooldownChase;
            }
        } else {
            this.runAway(this.dog, this.owner);
        }
    }

    private void chaseOwner(Dog dog, LivingEntity owner) {
        PathNavigation n = dog.m_21573_();
        BlockPos dog_b0 = dog.m_20183_();
        BlockPos owner_b0 = owner.m_20183_();
        double d0 = dog.m_20280_((Entity)owner);
        this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            if (d0 > 256.0) {
                this.tickTillPathRecalc += 5;
            }
            n.m_5624_((Entity)owner, 1.0);
        }
        if (n.m_26571_() && dog_b0.m_123331_((Vec3i)owner_b0) <= 4.0 && !this.canReachTarget(owner, d0)) {
            dog.m_21566_().m_6849_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 1.0);
        }
        if (n.m_26571_() && dog.f_19797_ % 2 != 0 && !this.canReachTarget(owner, d0)) {
            this.tickTillPathRecalc = 0;
        }
        if (this.checkAndTag(dog, owner)) {
            n.m_26573_();
            owner.m_213846_((Component)Component.m_237110_((String)"dog.msg.play_tag.gotcha", (Object[])new Object[]{dog.m_7755_().getString()}));
            this.dog.m_5496_(SoundEvents.f_12617_, 1.0f, 1.0f);
            this.ownerBeenTagged = true;
            this.cooldownChase = 30;
            this.timeLeft = 400;
            return;
        }
    }

    private boolean checkAndTag(Dog dog, LivingEntity owner) {
        if (this.canReachTarget(owner, dog.m_20280_((Entity)owner))) {
            dog.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void runAway(Dog dog, LivingEntity owner) {
        PathNavigation n = dog.m_21573_();
        double d = dog.m_20280_((Entity)owner);
        if (--this.tickTillLook <= 0) {
            this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
            if (this.tickTillLook <= -20) {
                this.tickTillLook = 20;
            }
        }
        if (n.m_26571_() && dog.f_19797_ % 2 != 0) {
            BlockPos b0 = this.getRandomPosAwayFromOwner(dog, owner);
            n.m_26519_((double)b0.m_123341_(), (double)b0.m_123342_(), (double)b0.m_123343_(), 1.0);
        }
        if (d < 9.0 && dog.f_19797_ % 10 == 0) {
            n.m_26573_();
        }
        if (this.cooldownChase > 0) {
            --this.cooldownChase;
        }
        if (this.canReachTarget(owner, d) && this.cooldownChase <= 0) {
            n.m_26573_();
            dog.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
            this.ownerBeenTagged = false;
            this.cooldownChase = 30;
            this.timeLeft = 400;
        }
    }

    private BlockPos getRandomPosAwayFromOwner(Dog dog, LivingEntity owner) {
        BlockPos owner_b0 = owner.m_20183_();
        RandomSource r = dog.m_217043_();
        int offSmall = 4;
        int offLarge = 20;
        int r1 = r.m_216332_(-offLarge, offLarge);
        int r2 = r.m_216332_(-offSmall, offSmall);
        r2 += Mth.m_14205_((double)r2) * 16;
        int dy = r.m_216332_(-2, 2);
        int dx = r1;
        int dz = r2;
        if (dog.m_217043_().m_188499_()) {
            dx = r2;
            dz = r1;
        }
        return owner_b0.m_7918_(dx, dy, dz);
    }

    @Override
    public void onStop() {
    }

    protected boolean canReachTarget(LivingEntity target, double distanceToTargetSqr) {
        return this.getTagReachSqr(target) >= distanceToTargetSqr;
    }

    protected double getTagReachSqr(LivingEntity target) {
        return this.dog.m_20205_() * 2.0f * this.dog.m_20205_() * 2.0f + target.m_20205_();
    }
}

