/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DogMoveControl
extends MoveControl {
    private static final float SNEAK_SPEED_1 = 0.35f;
    private static final float SNEAK_SPEED_2 = 0.25f;
    private Dog dog;
    private float forceSneak = -1.0f;

    public DogMoveControl(Dog dog) {
        super((Mob)dog);
        this.dog = dog;
    }

    public void m_8126_() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            this.doDogMoveTo();
            this.forceSneak = -1.0f;
            return;
        }
        if (this.f_24981_ == MoveControl.Operation.STRAFE) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            this.doDogStrafe();
            return;
        }
        super.m_8126_();
    }

    public void forceSneak(float val) {
        this.forceSneak = val;
    }

    private void doDogMoveTo() {
        boolean shouldJump;
        double dx = this.f_24975_ - this.dog.m_20185_();
        double dz = this.f_24977_ - this.dog.m_20189_();
        double dy = this.f_24976_ - this.dog.m_20186_();
        double l_sqr = dx * dx + dy * dy + dz * dz;
        if (l_sqr < 2.500000277905201E-7) {
            this.dog.m_21564_(0.0f);
            return;
        }
        double base_speed = this.dog.m_21133_(Attributes.f_22279_);
        double speed = base_speed * this.f_24978_;
        double dy_abs = Math.abs(dy);
        if (dy_abs > 0.75) {
            double speed_cap = dy_abs > 1.75 ? 0.25 : (double)0.35f;
            speed = Math.min(speed, speed_cap);
        }
        if (this.dog.isDogCurious()) {
            speed = Math.min(speed, 0.25);
        }
        if (this.forceSneak > 0.0f) {
            speed = Math.min(speed, (double)this.forceSneak);
        }
        float target_yrot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.2957763671875 - 90.0);
        float apporaching_yrot = speed < (double)0.39f ? this.m_24991_(this.dog.m_146908_(), target_yrot, 90.0f) : target_yrot;
        this.dog.m_146922_(apporaching_yrot);
        this.dog.m_7910_((float)speed);
        BlockPos b0 = this.dog.m_20183_();
        BlockState b0_state = this.dog.m_9236_().m_8055_(b0);
        VoxelShape b0_collision = b0_state.m_60812_((BlockGetter)this.dog.m_9236_(), b0);
        boolean dyRequiresJump = dy > (double)this.dog.m_274421_() && dx * dx + dz * dz < (double)Math.max(1.0f, this.dog.m_20205_());
        boolean collisionRequireJump = !b0_collision.m_83281_() && this.dog.m_20186_() < b0_collision.m_83297_(Direction.Axis.Y) + (double)b0.m_123342_() && !b0_state.m_204336_(BlockTags.f_13103_) && !b0_state.m_204336_(BlockTags.f_13039_) && !(b0_state.m_60734_() instanceof FenceGateBlock);
        boolean bl = shouldJump = dyRequiresJump || collisionRequireJump;
        if (shouldJump) {
            this.dog.m_146922_(target_yrot);
            this.dog.m_21569_().m_24901_();
            this.f_24981_ = MoveControl.Operation.JUMPING;
        }
    }

    private void doDogStrafe() {
        float check_z;
        float speed = (float)this.dog.m_21133_(Attributes.f_22279_);
        speed *= (float)this.f_24978_;
        float check_formard = this.f_24979_;
        float check_right = this.f_24980_;
        float check_length = Mth.m_14116_((float)(check_formard * check_formard + check_right * check_right));
        if (check_length > 1.0f) {
            check_formard /= check_length;
            check_right /= check_length;
        }
        float yrot_x = Mth.m_14031_((float)(this.dog.m_146908_() * ((float)Math.PI / 180)));
        float yrot_z = Mth.m_14089_((float)(this.dog.m_146908_() * ((float)Math.PI / 180)));
        float check_x = (check_right *= speed) * yrot_z + (check_formard *= speed) * -yrot_x;
        if (!this.isWalkableStrafe(check_x, check_z = check_right * yrot_x + check_formard * yrot_z)) {
            this.dog.m_7910_(0.0f);
            this.dog.m_21564_(0.0f);
            this.dog.m_21570_(0.0f);
            return;
        }
        this.f_24974_.m_7910_(speed);
        this.f_24974_.m_21564_(this.f_24979_);
        this.f_24974_.m_21570_(this.f_24980_);
    }

    private boolean isWalkableStrafe(float dx, float dz) {
        PathNavigation nav = this.dog.m_21573_();
        if (nav == null) {
            return false;
        }
        NodeEvaluator node_eval = nav.m_26575_();
        if (node_eval == null) {
            return false;
        }
        BlockPos check_pos = BlockPos.m_274561_((double)(this.dog.m_20185_() + (double)dx), (double)this.f_24974_.m_146904_(), (double)(this.f_24974_.m_20189_() + (double)dz));
        boolean is_walkable = node_eval.m_8086_((BlockGetter)this.dog.m_9236_(), check_pos.m_123341_(), check_pos.m_123342_(), check_pos.m_123343_()) == BlockPathTypes.WALKABLE;
        return is_walkable;
    }
}

