/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyTalents;
import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.AABB;

public class GuardModeGoal
extends NearestAttackableTargetGoal<Mob> {
    private final Dog dog;
    private LivingEntity owner;
    private static final int GUARD_DISTANCE = 6;
    private static final int GUARD_DISTANCE_SQR = 36;
    private static final int START_FOLLOW_DISTANCE_SQR = 6;
    private static final int STOP_FOLLOW_DISTANCE_SQR = 4;

    public GuardModeGoal(Dog dog) {
        super((Mob)dog, Mob.class, 3, false, false, e -> e instanceof Enemy);
        this.dog = dog;
    }

    public boolean m_8036_() {
        this.owner = this.dog.m_269323_();
        if (this.owner == null) {
            return false;
        }
        if (!this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT)) {
            return false;
        }
        return super.m_8036_();
    }

    protected double m_7623_() {
        return 12.0f * Mth.f_13994_ + 1.0f;
    }

    protected void m_26073_() {
        this.f_26050_ = this.dog.m_9236_().m_45963_(this.f_26048_, this.f_26051_, (LivingEntity)this.dog, this.owner.m_20185_(), this.owner.m_20188_(), this.owner.m_20189_(), this.m_7255_(6.0));
    }

    public void m_8041_() {
        this.owner = null;
    }

    public static class Major
    extends Goal {
        private final Dog dog;
        private LivingEntity owner;
        private int tickUntilPathRecalc = 0;

        public Major(Dog dog) {
            this.dog = dog;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT)) {
                return false;
            }
            if (this.dog.isLowHunger()) {
                return false;
            }
            this.owner = this.dog.m_269323_();
            if (this.owner == null) {
                return false;
            }
            LivingEntity target = this.dog.m_5448_();
            return target == null || !(target.m_20280_((Entity)this.owner) <= 36.0);
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            double dist_owner_sqr = this.dog.m_20280_((Entity)this.owner);
            if (this.tickUntilPathRecalc > 0) {
                --this.tickUntilPathRecalc;
            }
            if (dist_owner_sqr >= 6.0 && this.tickUntilPathRecalc <= 0) {
                this.tickUntilPathRecalc = 5;
                if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                    if (this.dog.m_20280_((Entity)this.owner) > 36.0) {
                        DogUtil.guessAndTryToTeleportToOwner(this.dog, this.owner, 4);
                    } else {
                        float speed = dist_owner_sqr <= 9.0 ? 1.0f : this.dog.getUrgentSpeedModifier();
                        this.dog.m_21573_().m_5624_((Entity)this.owner, (double)speed);
                    }
                }
            }
            if (dist_owner_sqr < 4.0) {
                this.dog.breakMoveControl();
                this.dog.m_21573_().m_26573_();
            }
        }

        public void m_8041_() {
            this.owner = null;
        }
    }

    public static class Minor
    extends Goal {
        private final Dog dog;
        private LivingEntity owner;
        private LivingEntity nearestDanger;
        private int searchTimestamp = 0;
        private int growlCoolDownEnd = 0;
        private int tickUntilPathRecalc = 0;
        private final int SEARCH_RADIUS = 6;

        public Minor(Dog dog) {
            this.dog = dog;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.dog.isMode(DogMode.GUARD_MINOR)) {
                return false;
            }
            if (this.dog.isLowHunger()) {
                return false;
            }
            this.owner = this.dog.m_269323_();
            return this.owner != null;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            if (this.nearestDanger != null) {
                this.dog.m_21563_().m_24960_((Entity)this.nearestDanger, 10.0f, (float)this.dog.m_8132_());
            }
            double dist_owner_sqr = this.dog.m_20280_((Entity)this.owner);
            if (this.tickUntilPathRecalc > 0) {
                --this.tickUntilPathRecalc;
            }
            if (dist_owner_sqr >= 6.0 && this.tickUntilPathRecalc <= 0) {
                this.tickUntilPathRecalc = 5;
                if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                    if (this.dog.m_20280_((Entity)this.owner) > 36.0) {
                        DogUtil.guessAndTryToTeleportToOwner(this.dog, this.owner, 4);
                    } else {
                        float speed = dist_owner_sqr <= 9.0 ? 1.0f : this.dog.getUrgentSpeedModifier();
                        this.dog.m_21573_().m_5624_((Entity)this.owner, (double)speed);
                    }
                }
            }
            if (dist_owner_sqr < 4.0) {
                this.dog.breakMoveControl();
                this.dog.m_21573_().m_26573_();
            }
            if (this.dog.f_19797_ >= this.searchTimestamp) {
                int max_timestamp;
                this.searchTimestamp = this.dog.f_19797_ + 10;
                boolean wasSafe = this.nearestDanger == null;
                this.findDanger();
                if (this.nearestDanger != null && wasSafe && this.growlCoolDownEnd > (max_timestamp = this.dog.f_19797_ + 20)) {
                    this.growlCoolDownEnd = max_timestamp;
                }
            }
            if (this.nearestDanger != null && this.dog.f_19797_ >= this.growlCoolDownEnd) {
                this.growlCoolDownEnd = this.dog.f_19797_ + 50;
                SoundEvent sound = this.dog.dogMood.getSeriousGrowl();
                this.dog.m_5496_(sound, 1.0f, (this.dog.m_217043_().m_188501_() - this.dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
        }

        protected void findDanger() {
            if (this.dog.getDogLevel((Supplier)DoggyTalents.RESCUE_DOG) > 0) {
                return;
            }
            this.nearestDanger = this.dog.m_9236_().m_45963_(Mob.class, TargetingConditions.m_148352_().m_26888_(target -> {
                if (this.dog.getDogLevel((Supplier)DoggyTalents.CREEPER_SWEEPER) > 0) {
                    return target instanceof Creeper;
                }
                return target instanceof Enemy;
            }), (LivingEntity)this.dog, this.owner.m_20185_(), this.owner.m_20188_(), this.owner.m_20189_(), new AABB(this.owner.m_20183_()).m_82377_(6.0, 4.0, 6.0));
        }

        public void m_8041_() {
            this.owner = null;
        }
    }
}

