/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DogVariants;
import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogWantsAttentionGoal
extends Goal {
    private final Dog dog;
    private LivingEntity owner;
    private int lastStopTick;
    private int cooldownTime = 200;
    private Phase phase = Phase.GO_TO_OWNER;
    private int goToOwnerTimeout;
    private int tickTillPathRecalc;
    private boolean whinedToAttention;
    private int tickAnim;
    private int stopTick;

    public DogWantsAttentionGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.m_6060_()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        if (this.dog.f_19797_ - this.lastStopTick < this.cooldownTime) {
            return false;
        }
        if (this.dog.dogVariant() != DogVariants.CHESTNUT.get()) {
            return false;
        }
        if (this.dog.m_217043_().m_188501_() >= 0.01f) {
            return false;
        }
        LivingEntity owner = this.dog.m_269323_();
        if (owner == null) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (this.phase == Phase.GO_TO_OWNER) {
            return this.goToOwnerTimeout > 0;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.PLAY_WITH_MEH) {
            return false;
        }
        if (this.dog.m_20280_((Entity)this.owner) > 16.0) {
            return false;
        }
        return this.dog.f_19797_ < this.stopTick;
    }

    public void m_8056_() {
        this.phase = Phase.GO_TO_OWNER;
        this.goToOwnerTimeout = 200;
        this.whinedToAttention = false;
    }

    public void m_8037_() {
        if (this.phase == Phase.GO_TO_OWNER) {
            this.tickGoToOwner();
        } else {
            this.tickBegForAttention();
        }
    }

    private void tickGoToOwner() {
        boolean closeEnough;
        this.dog.m_21563_().m_148051_((Entity)this.owner);
        if (--this.goToOwnerTimeout <= 0) {
            this.goToOwnerTimeout = 0;
            return;
        }
        double d0 = this.dog.m_20280_((Entity)this.owner);
        boolean bl = closeEnough = d0 < 6.0;
        if (--this.tickTillPathRecalc <= 0) {
            if (!closeEnough) {
                this.dog.m_21573_().m_5624_((Entity)this.owner, 1.0);
            }
            this.tickTillPathRecalc = 20;
        }
        if (closeEnough) {
            if (!this.dog.m_21573_().m_26571_()) {
                this.dog.m_21573_().m_26573_();
            }
            if (!this.whinedToAttention) {
                this.whinedToAttention = true;
                this.dog.m_5496_(SoundEvents.f_12625_, this.dog.m_6121_(), this.dog.m_6100_());
            }
            this.checkAndSwitchToAttention();
        }
    }

    private void checkAndSwitchToAttention() {
        if (!DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
            return;
        }
        this.phase = Phase.BEG_FOR_ATTENTION;
        this.tickAnim = 0;
        this.stopTick = this.dog.f_19797_ + DogAnimation.PLAY_WITH_MEH.getLengthTicks();
        this.dog.setAnim(DogAnimation.PLAY_WITH_MEH);
    }

    private void tickBegForAttention() {
        this.dog.m_21563_().m_148051_((Entity)this.owner);
    }

    public void m_8041_() {
        this.owner = null;
        this.lastStopTick = this.dog.f_19797_;
        this.cooldownTime = 20 * (1 + this.dog.m_217043_().m_188503_(3));
        if (this.dog.getAnim() == DogAnimation.PLAY_WITH_MEH) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private static enum Phase {
        GO_TO_OWNER,
        BEG_FOR_ATTENTION;

    }
}

