/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAttackManager;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.entity.ai.nav.DogFlyingNavigation;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DogMeleeAttackGoal
extends Goal
implements DogAiManager.IHasTickNonRunning {
    protected final Dog dog;
    private final double speedModifier;
    private int ticksUntilPathRecalc = 10;
    private int ticksUntilNextAttack;
    private final int timeOutTick = 40;
    private int waitingTick;
    private BlockPos.MutableBlockPos dogPos0;
    private boolean immediatelyPathRecalcWhenStop = false;
    private Path initialPath = null;
    private int detectReachPenalty = 0;
    private final float START_LEAPING_AT_DIS_SQR = 2.0f;
    private final float DONT_LEAP_AT_DIS_SQR = 1.0f;
    private final float LEAP_YD = 0.4f;

    public DogMeleeAttackGoal(Dog dog) {
        this.dog = dog;
        this.speedModifier = 1.0;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target;
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.isDogLowHealth() && this.dog.getLowHealthStrategy() == Dog.LowHealthStrategy.RUN_AWAY) {
            return false;
        }
        if (this.dog.f_19789_ > 7.0f) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            LivingEntity owner = this.dog.m_269323_();
            if (owner != null && this.dog.m_20280_((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            restriction = !this.dog.patrolTargetLock();
        }
        if ((target = this.dog.m_5448_()) == null) {
            return false;
        }
        if (!target.m_6084_()) {
            this.dog.m_6710_(null);
            return false;
        }
        if (target.m_20186_() >= (double)this.dog.m_9236_().m_151558_()) {
            return false;
        }
        if (this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        if (restriction && !this.dog.m_21444_(target.m_20183_())) {
            return false;
        }
        if (this.detectReachPenalty > 0) {
            return false;
        }
        double d0 = this.dog.m_20280_((Entity)target);
        this.detectReachPenalty = 5;
        this.detectReachPenalty += d0 > 256.0 ? 10 : 5;
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        if (attack_manager.hasTaticalTarget()) {
            this.detectReachPenalty = 25;
            attack_manager.setDogFarChasingTarget(true);
            this.initialPath = this.dog.m_21573_().m_6570_((Entity)target, 1);
            attack_manager.setDogFarChasingTarget(false);
            return this.initialPath != null;
        }
        Path p = this.dog.m_21573_().m_6570_((Entity)target, 1);
        if (p == null) {
            return false;
        }
        if (!DogUtil.canPathReachTargetBlock(this.dog, p, target.m_20183_(), 1, this.dog.m_6056_())) {
            this.dog.m_6710_(null);
            return false;
        }
        this.initialPath = p;
        return true;
    }

    @Override
    public void tickDogWhenNotRunning() {
        if (this.detectReachPenalty > 0) {
            --this.detectReachPenalty;
        }
    }

    public boolean m_8045_() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.f_19789_ > 7.0f) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            LivingEntity owner = this.dog.m_269323_();
            if (owner != null && this.dog.m_20280_((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            boolean bl = restriction = !this.dog.patrolTargetLock();
        }
        if (this.waitingTick > this.timeOutTick) {
            return false;
        }
        LivingEntity livingentity = this.dog.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (livingentity.m_20186_() >= (double)this.dog.m_9236_().m_151558_()) {
            return false;
        }
        if (restriction && !this.dog.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        if (this.initialPath != null) {
            this.dog.m_21573_().m_26536_(this.initialPath, this.speedModifier);
        }
        this.ticksUntilPathRecalc = 10;
        this.ticksUntilNextAttack = 0;
        this.waitingTick = 0;
        this.dogPos0 = this.dog.m_20183_().m_122032_();
        this.immediatelyPathRecalcWhenStop = this.checkCurrentPathIfCanDoImmediateRecalc();
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = true;
        if (attack_manager.hasTaticalTarget()) {
            attack_manager.setDogFarChasingTarget(true);
        }
    }

    public void m_8041_() {
        this.initialPath = null;
        this.dog.m_6710_(null);
        this.dog.m_21573_().m_26573_();
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = false;
        attack_manager.setDogFarChasingTarget(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double min_dist;
        double d0;
        LivingEntity e = this.dog.m_5448_();
        if (e == null) {
            return;
        }
        PathNavigation n = this.dog.m_21573_();
        BlockPos dog_bp = this.dog.m_20183_();
        BlockPos target_bp = e.m_20183_();
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        if (attack_manager.isDogFarChasingTarget() && (d0 = this.dog.m_20275_(e.m_20185_(), e.m_20186_(), e.m_20189_())) < (min_dist = (double)(attack_manager.getStandardFollowRange() / 2 + 1)) * min_dist) {
            attack_manager.setDogFarChasingTarget(false);
        }
        if (this.dog.isDogFlying() && this.flyingDogDashToTargetIfNeeded(e)) {
            return;
        }
        if (dog_bp.equals((Object)this.dogPos0)) {
            ++this.waitingTick;
        } else {
            this.waitingTick = 0;
            this.dogPos0.m_122178_(dog_bp.m_123341_(), dog_bp.m_123342_(), dog_bp.m_123343_());
        }
        this.dog.m_21563_().m_24960_((Entity)e, 30.0f, 30.0f);
        d0 = this.dog.m_20275_(e.m_20185_(), e.m_20186_(), e.m_20189_());
        if (this.ticksUntilPathRecalc <= 0) {
            this.ticksUntilPathRecalc = 10;
            if (attack_manager.isDogFarChasingTarget()) {
                this.ticksUntilPathRecalc = 20;
            }
            n.m_5624_((Entity)e, this.speedModifier);
            this.immediatelyPathRecalcWhenStop = this.checkCurrentPathIfCanDoImmediateRecalc();
        }
        --this.ticksUntilPathRecalc;
        --this.ticksUntilNextAttack;
        if (n.m_26571_() && dog_bp.m_123331_((Vec3i)target_bp) <= 2.25 && !this.canReachTarget(e, d0) && this.isTargetInSafeArea(this.dog, e, target_bp)) {
            this.dog.m_21566_().m_6849_(e.m_20185_(), e.m_20186_(), e.m_20189_(), this.speedModifier);
        }
        if (!attack_manager.isDogFarChasingTarget() && this.immediatelyPathRecalcWhenStop && n.m_26571_() && this.dog.f_19797_ % 2 != 0 && !this.canReachTarget(e, d0)) {
            this.ticksUntilPathRecalc = 0;
        }
        if (this.checkAndPerformAttack(e, d0)) {
            this.waitingTick = 0;
        }
        this.checkAndLeapAtTarget(e);
    }

    protected void checkAndLeapAtTarget(LivingEntity target) {
        if (!this.canLeapAtTarget(target)) {
            return;
        }
        Vec3 vec3 = this.dog.m_20184_();
        Vec3 vec31 = new Vec3(target.m_20185_() - this.dog.m_20185_(), 0.0, target.m_20189_() - this.dog.m_20189_());
        if (vec31.m_82556_() > 1.0E-7) {
            vec31 = vec31.m_82541_().m_82490_(0.4);
        }
        double d = vec31.f_82479_;
        Objects.requireNonNull(this);
        this.dog.m_20334_(d, 0.4f, vec31.f_82481_);
    }

    private boolean flyingDogDashToTargetIfNeeded(LivingEntity target) {
        double d_sqr = this.dog.m_20280_((Entity)target);
        if (d_sqr > 16.0) {
            return false;
        }
        if (this.dog.f_19797_ % 5 != 0) {
            return false;
        }
        PathNavigation pathNavigation = this.dog.m_21573_();
        if (!(pathNavigation instanceof DogFlyingNavigation)) {
            return false;
        }
        DogFlyingNavigation flyNav = (DogFlyingNavigation)pathNavigation;
        if (!flyNav.canDashToTarget(target)) {
            return false;
        }
        flyNav.m_26573_();
        this.dog.m_21566_().m_6849_(target.m_20182_().f_82479_, target.m_20182_().f_82480_, target.m_20182_().f_82481_, 2.0);
        this.ticksUntilPathRecalc = 10;
        return true;
    }

    protected boolean canLeapAtTarget(@NotNull LivingEntity target) {
        if (this.dog.m_20160_()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        if (!target.m_20096_()) {
            return false;
        }
        double d0 = this.dog.m_20280_((Entity)target);
        if (!(d0 >= 1.0) || !(d0 <= 2.0)) {
            return false;
        }
        if (this.dog.m_217043_().m_188503_(3) != 0) {
            return false;
        }
        BlockPos tpos = target.m_20183_();
        if (WalkNodeEvaluator.m_77604_((BlockGetter)this.dog.m_9236_(), (BlockPos.MutableBlockPos)tpos.m_122032_()) != BlockPathTypes.WALKABLE) {
            return false;
        }
        Vec3 v_offset = new Vec3(target.m_20185_() - this.dog.m_20185_(), 0.0, target.m_20189_() - this.dog.m_20189_()).m_82541_();
        Vec3 v_dog = this.dog.m_20182_();
        for (int i = 1; i <= 3; ++i) {
            v_dog = v_dog.m_82549_(v_offset);
            if (WalkNodeEvaluator.m_77604_((BlockGetter)this.dog.m_9236_(), (BlockPos.MutableBlockPos)BlockPos.m_274446_((Position)v_dog).m_122032_()) == BlockPathTypes.WALKABLE) continue;
            return false;
        }
        return true;
    }

    private boolean checkCurrentPathIfCanDoImmediateRecalc() {
        boolean ground_nav_cannot_update;
        Path path = this.dog.m_21573_().m_26570_();
        boolean bl = ground_nav_cannot_update = this.dog.isDefaultNavigation() && !this.dog.m_20096_();
        if (path == null && !ground_nav_cannot_update) {
            return false;
        }
        return path == null || path.m_77398_() <= 5;
    }

    protected boolean checkAndPerformAttack(LivingEntity target, double distanceToTargetSqr) {
        if (this.canReachTarget(target, distanceToTargetSqr) && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.dog.m_6674_(InteractionHand.MAIN_HAND);
            this.dog.m_7327_((Entity)target);
            return true;
        }
        return false;
    }

    protected boolean isTargetInSafeArea(Dog dog, LivingEntity target, BlockPos target_bp) {
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)dog.m_9236_(), (BlockPos.MutableBlockPos)target_bp.m_122032_());
        if (type == BlockPathTypes.OPEN) {
            return false;
        }
        return (type = dog.inferType(type, InferTypeContext.getDefault())).getDanger() == null;
    }

    protected boolean canReachTarget(LivingEntity target, double distanceToTargetSqr) {
        return this.getAttackReachSqr(target) >= distanceToTargetSqr;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }

    protected double getAttackReachSqr(LivingEntity target) {
        return this.dog.m_20205_() * 2.0f * this.dog.m_20205_() * 2.0f + target.m_20205_();
    }

    protected double getMaxDistanceAwayFromOwner() {
        boolean has_tatical;
        double ret = 400.0;
        if (this.dog.getCombatReturnStrategy() == Dog.CombatReturnStrategy.FAR) {
            ret = 1024.0;
        }
        if (has_tatical = this.dog.dogAttackManager.hasTaticalTarget()) {
            ret += 10.0;
        }
        return ret;
    }
}

