/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.phys.Vec3;

public class DogGoBackToSitAfterFinishAction
extends Goal {
    private final Dog dog;
    private double oldRangeSense = 16.0;
    private static final double TEMP_HIGH_SENSE = 32.0;
    private Optional<Integer> lastPathCalcAt = Optional.empty();
    private int pathCalcDelay = 0;
    private boolean hasDelayCalc = false;
    private Optional<BlockPos> delayedCalcTo = Optional.empty();

    public DogGoBackToSitAfterFinishAction(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        Optional<BlockPos> sit_pos_optional = this.checkAndInvalidateSitPos();
        if (!sit_pos_optional.isPresent()) {
            return false;
        }
        return !this.dog.dogAi.getActiveAction().isPresent();
    }

    private Optional<BlockPos> checkAndInvalidateSitPos() {
        Optional<BlockPos> sit_pos_optional = this.dog.getDogSitOverridePos();
        if (!sit_pos_optional.isPresent()) {
            return Optional.empty();
        }
        BlockPos sit_pos = sit_pos_optional.get();
        int sit_timestamp = this.dog.getDogSitOverridePosTimestamp();
        int time_since_save = this.dog.f_19797_ - sit_timestamp;
        if (time_since_save > 600) {
            this.dog.clearDogSitOverridePos();
            return Optional.empty();
        }
        double max_validated_dist = 20.0;
        if (this.dog.m_20238_(Vec3.m_82539_((Vec3i)sit_pos)) > 400.0) {
            this.dog.clearDogSitOverridePos();
            return Optional.empty();
        }
        return Optional.of(sit_pos);
    }

    public boolean m_8045_() {
        return this.hasDelayCalc || !this.dog.m_21573_().m_26571_();
    }

    public void m_8056_() {
        Optional<BlockPos> sit_pos_optional;
        AttributeInstance attrib = this.dog.m_21051_(Attributes.f_22277_);
        if (attrib != null) {
            this.oldRangeSense = attrib.m_22135_();
            attrib.m_22100_(32.0);
        }
        if (!(sit_pos_optional = this.dog.getDogSitOverridePos()).isPresent()) {
            return;
        }
        BlockPos sit_pos = sit_pos_optional.get();
        if (!this.maySetCalcPathDelayed(sit_pos)) {
            this.calcPath(sit_pos);
        }
    }

    private boolean maySetCalcPathDelayed(BlockPos pos) {
        if (!this.lastPathCalcAt.isPresent()) {
            return false;
        }
        int time_since_last = this.dog.f_19797_ - this.lastPathCalcAt.get();
        if (time_since_last > 20) {
            return false;
        }
        this.hasDelayCalc = true;
        this.delayedCalcTo = Optional.of(pos);
        this.pathCalcDelay = Math.max(0, 20 - time_since_last);
        return true;
    }

    public void m_8037_() {
        if (!this.hasDelayCalc) {
            return;
        }
        if (this.pathCalcDelay > 0) {
            --this.pathCalcDelay;
        }
        if (this.pathCalcDelay <= 0) {
            this.hasDelayCalc = false;
            this.delayedCalcTo.ifPresent(x -> this.calcPath((BlockPos)x));
        }
    }

    public void calcPath(BlockPos pos) {
        PathNavigation nav = this.dog.m_21573_();
        nav.m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1.0);
        if (nav instanceof DogPathNavigation) {
            DogPathNavigation dog_nav = (DogPathNavigation)nav;
            dog_nav.setDogMoveInTargetNode();
        }
        this.lastPathCalcAt = Optional.of(this.dog.f_19797_);
    }

    public void m_8041_() {
        AttributeInstance attrib = this.dog.m_21051_(Attributes.f_22277_);
        if (attrib != null) {
            attrib.m_22100_(this.oldRangeSense);
        }
        this.dog.m_21839_(true);
        this.dog.clearDogSitOverridePos();
    }

    public boolean m_183429_() {
        return true;
    }
}

