/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyEntityTypes;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAllyCheck;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;

public class DogProjectileHitAllyHandler {
    public static boolean onCheckIfCanHitTarget(Projectile proj, Entity target) {
        boolean entity_type_condition;
        Entity proj_owner = proj.m_19749_();
        if (proj_owner == null || target == null) {
            return false;
        }
        boolean bl = entity_type_condition = proj_owner.m_6095_() == DoggyEntityTypes.DOG.get() || target.m_6095_() == DoggyEntityTypes.DOG.get();
        if (!entity_type_condition) {
            return false;
        }
        if (DogProjectileHitAllyHandler.shouldProjectileStillHitAlly(proj, proj_owner, target)) {
            return false;
        }
        Entity maybe_dog = null;
        Entity other = null;
        if (proj_owner.m_6095_() == DoggyEntityTypes.DOG.get()) {
            maybe_dog = proj_owner;
            other = target;
        } else {
            maybe_dog = target;
            other = proj_owner;
        }
        if (!(maybe_dog instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)maybe_dog;
        boolean result = DogAllyCheck.isAlliedToDog(dog, other);
        return result;
    }

    public static boolean shouldProjectileStillHitAlly(Projectile proj, Entity proj_owner, Entity target) {
        return proj.m_6095_() == EntityType.f_20477_ && proj_owner.m_6095_() == EntityType.f_20532_;
    }
}

