/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.UUID;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DogHungerManager {
    public static final UUID HUNGER_MOVEMENT = UUID.fromString("50671f49-1dfd-4397-242b-78bb6b178115");
    public static final float MAX_HUNGER_TICK = 800.0f;
    private final Dog dog;
    private float hungerTick = 0.0f;
    private int saturation = 0;
    private int saturationHealingTick = 0;
    private int hungerDamageTick = 0;
    private boolean lowHunger = false;
    private boolean zeroHunger = false;

    public DogHungerManager(Dog dog) {
        this.dog = dog;
    }

    public void tick() {
        this.handleHunger();
        this.mayHealWithSaturation();
    }

    private void handleHunger() {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue()) {
            return;
        }
        if (this.dog.getMode() == DogMode.WANDERING && ((Boolean)ConfigHandler.SERVER.WANDERING_DOG_NON_HUNGER.get()).booleanValue()) {
            return;
        }
        if (this.dog.isDogInAnimDebug()) {
            return;
        }
        this.hungerTick += this.getIncreaseHungerTick();
        if (this.hungerTick >= 800.0f) {
            if (this.saturation > 0) {
                --this.saturation;
            } else {
                this.dog.setDogHunger(this.dog.getDogHunger() - 1.0f);
            }
            this.hungerTick = 0.0f;
        }
        if (this.zeroHunger) {
            this.handleZeroHunger();
        }
    }

    private float getIncreaseHungerTick() {
        float inc_tick = 0.0f;
        if (!this.dog.m_20160_() && !this.dog.m_21825_()) {
            inc_tick = 1.0f;
        }
        if (!this.dog.m_21573_().m_26571_()) {
            inc_tick = 2.0f;
        }
        for (IDogAlteration alter : this.dog.getAlterations()) {
            InteractionResultHolder<Float> result = alter.hungerTick(this.dog, inc_tick);
            if (!result.m_19089_().m_19080_()) continue;
            inc_tick = ((Float)result.m_19095_()).floatValue();
        }
        float modifier = ((Double)ConfigHandler.SERVER.HUNGER_MODIFIER.get()).floatValue();
        return inc_tick * modifier;
    }

    private void handleZeroHunger() {
        ++this.hungerDamageTick;
        int hurt_interval = -1;
        boolean hurt_last_health = false;
        switch (this.dog.m_9236_().m_46791_()) {
            case EASY: {
                hurt_interval = 125;
                break;
            }
            case NORMAL: {
                hurt_interval = 100;
                break;
            }
            case HARD: {
                hurt_interval = 75;
                hurt_last_health = true;
                break;
            }
            default: {
                hurt_interval = -1;
            }
        }
        if (hurt_interval >= 0 && ++this.hungerDamageTick >= hurt_interval && (hurt_last_health || this.dog.m_21223_() > 1.0f)) {
            this.dog.m_6469_(this.dog.m_269291_().m_269064_(), 0.5f);
            this.hungerDamageTick = 0;
        }
    }

    private void mayHealWithSaturation() {
        if (this.saturation <= 0) {
            return;
        }
        if (this.dog.m_21223_() >= this.dog.m_21233_()) {
            return;
        }
        if (--this.saturationHealingTick <= 0) {
            this.saturationHealingTick = 10;
            this.dog.m_5634_(2.0f);
            this.saturation -= 3;
        }
    }

    public int saturation() {
        return this.saturation;
    }

    public boolean isLowHunger() {
        return this.lowHunger;
    }

    public void onHungerUpdated(float new_hunger) {
        boolean lowHunger_updated;
        if (this.dog.m_9236_().f_46443_) {
            return;
        }
        boolean bl = lowHunger_updated = new_hunger <= 10.0f;
        if (this.lowHunger && !lowHunger_updated) {
            this.hungerLowToHigh();
        }
        if (!this.lowHunger && lowHunger_updated) {
            this.hungerHighToLow();
        }
        this.lowHunger = lowHunger_updated;
        this.zeroHunger = new_hunger <= 0.0f;
    }

    private void hungerHighToLow() {
        if (!this.dog.isDefeated()) {
            this.dog.setAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT, (d, u) -> new AttributeModifier(u, "Hunger Slowness", (double)-0.35f, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private void hungerLowToHigh() {
        this.dog.removeAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT);
    }

    public void onBeingIncapacitated() {
        this.dog.removeAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT);
    }

    public void addHunger(float add) {
        float h0 = this.dog.getDogHunger();
        float h1 = h0 + add;
        int h2 = (int)(h1 - this.dog.getMaxHunger());
        if (h2 > 0) {
            this.saturation = Math.max(this.saturation, h2);
        }
        this.dog.setDogHunger(h0 + add);
    }
}

