/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.common.entity.Dog;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ProjectileWeaponItem;

public class DogAvoidGoingInFrontOfOwnerManager {
    private Dog dog;
    private int activeTime = 0;
    private static final int ACTIVE_DURATION = 600;

    public DogAvoidGoingInFrontOfOwnerManager(Dog dog) {
        this.dog = dog;
    }

    public void tick() {
        if (this.activeTime > 0) {
            --this.activeTime;
        }
        if ((this.dog.f_19797_ & 1) != 0) {
            return;
        }
        LivingEntity owner = this.dog.m_269323_();
        if (owner == null) {
            return;
        }
        if (this.shouldAvoidGoingInfrontOfOwner(owner)) {
            this.activeTime = 600;
        }
    }

    public boolean isActive() {
        return this.activeTime > 0;
    }

    private boolean shouldAvoidGoingInfrontOfOwner(LivingEntity owner) {
        return this.ownerMayBeMining(owner) || this.ownerIsShooting(owner);
    }

    private boolean ownerIsShooting(LivingEntity owner) {
        return owner.m_6117_() && owner.m_21205_().m_41720_() instanceof ProjectileWeaponItem;
    }

    private boolean ownerMayBeMining(LivingEntity owner) {
        return owner.f_20911_ && owner.m_21205_().m_41720_() instanceof DiggerItem;
    }
}

