/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.AccessoryView;

import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.DogStatusViewBoxElement;
import doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.widget.AccessoryHolder;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.DivElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.common.entity.Dog;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class DogAccessoriesElement
extends AbstractElement {
    private static final int BUTTON_SPACING = 4;
    Dog dog;
    Minecraft mc;
    final ArrayList<AccessoryHolder> accessoryHolders = new ArrayList(5);
    DivElement dogDiv;
    DivElement accessoriesDiv;
    Font font;
    AccessoryHolder wolfArmorHolder;

    public DogAccessoriesElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        this.mc = Minecraft.m_91087_();
        this.font = this.mc.f_91062_;
    }

    @Override
    public AbstractElement init() {
        this.dogDiv = new DivElement(this, this.getScreen());
        this.accessoriesDiv = new DivElement(this, this.getScreen());
        this.dogDiv.setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(0.5f, 1.0f);
        this.addChildren((GuiEventListener)this.dogDiv);
        this.accessoriesDiv.setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(0.5f, 1.0f);
        int mX = this.accessoriesDiv.getSizeX() / 2;
        int mY = this.accessoriesDiv.getSizeY() / 2;
        for (int i = 0; i < 5; ++i) {
            AccessoryHolder accessoryHolder = new AccessoryHolder(0, 0, this.mc.m_91291_(), this.dog, false);
            this.accessoryHolders.add(accessoryHolder);
        }
        int accessoryHolderTotalsSize = 106;
        int startX = this.accessoriesDiv.getRealX() + mX - 9;
        int pY = this.accessoriesDiv.getRealY() + mY - accessoryHolderTotalsSize / 2;
        for (AccessoryHolder holder : this.accessoryHolders) {
            holder.m_252865_(startX);
            holder.m_253211_(pY);
            this.accessoriesDiv.addChildren((GuiEventListener)holder);
            pY += 22;
        }
        this.addChildren((GuiEventListener)this.accessoriesDiv);
        int armorHolderX = this.getRealX() + 10;
        int armorHolderY = this.getRealY() + 10;
        this.wolfArmorHolder = new AccessoryHolder(armorHolderX, armorHolderY, this.mc.m_91291_(), this.dog, false);
        this.addChildren((GuiEventListener)this.wolfArmorHolder);
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.dogDiv.getSizeX() / 2;
        int mY = this.dogDiv.getSizeY() / 2;
        int e_mX = this.dogDiv.getRealX() + mX;
        int e_mY = this.dogDiv.getRealY() + mY;
        DogStatusViewBoxElement.renderDogInside(graphics, this.dog, e_mX, e_mY + 32, 50, e_mX - mouseX, e_mY - mouseY);
        boolean noRenderAccessory = false;
        int holderIndx = 0;
        List<AccessoryInstance> accessories = this.dog.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            DogModel model;
            AccessoryInstance accessory = accessories.get(i);
            DogSkin skin = this.dog.getClientSkin();
            if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).acessoryShouldRender(this.dog, accessory)) {
                noRenderAccessory = true;
            }
            if (holderIndx >= this.accessoryHolders.size()) break;
            ItemStack item = accessory.getReturnItem();
            if (item == null) continue;
            AccessoryHolder holder = this.accessoryHolders.get(holderIndx);
            holder.setStack(item);
            holder.setInventorySlotId(i);
            holder.warning = false;
            if (skin.useCustomModel()) {
                DogModel model2 = skin.getCustomModel().getValue();
                holder.warning = model2.warnAccessory(this.dog, accessory.getAccessory());
            }
            ++holderIndx;
        }
        while (holderIndx < this.accessoryHolders.size()) {
            this.accessoryHolders.get(holderIndx).setStack(ItemStack.f_41583_);
            ++holderIndx;
        }
        if (noRenderAccessory) {
            this.drawNoRenderAccessoryWarning(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.dog.hasWolfArmor()) {
            this.wolfArmorHolder.setStack(this.dog.wolfArmor());
        } else {
            this.wolfArmorHolder.setStack(ItemStack.f_41583_);
        }
    }

    private void drawNoRenderAccessoryWarning(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent txt = Component.m_237115_((String)"doggui.invalid_dog.accessory_no_render_warn");
        List lines = this.font.m_92923_((FormattedText)txt, this.getSizeX() - 30);
        int pX = this.getRealX() + this.getSizeX() / 2;
        int n = this.getRealY() + this.getSizeY();
        Objects.requireNonNull(this.font);
        int pY = n - 9 - 3;
        for (int i = lines.size() - 1; i >= 0; --i) {
            pX = this.getRealX() + this.getSizeX() / 2 - this.font.m_92724_((FormattedCharSequence)lines.get(i)) / 2;
            graphics.m_280648_(this.font, (FormattedCharSequence)lines.get(i), pX, pY, -3299584);
            Objects.requireNonNull(this.font);
            pY -= 9 + 3;
        }
    }
}

