/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.lib.Resources;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class IncapacitatedRenderer
extends RenderLayer<Dog, DogModel> {
    private DogModel defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();

    public IncapacitatedRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogIncapacitatedMananger.IncapacitatedSyncState sync_state;
        ResourceLocation texture_rl;
        DogModel model;
        if (!dog.m_21824_() || dog.m_20145_()) {
            return;
        }
        if (!dog.isDefeated()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).incapShouldRender(dog)) {
            return;
        }
        if (!((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_INCAPACITATED_TEXTURE)).booleanValue()) {
            return;
        }
        DogModel dogModel = (DogModel)this.m_117386_();
        if (dogModel.useDefaultModelForAccessories()) {
            dogModel.m_102624_(this.defaultModel);
            this.defaultModel.copyFrom(dogModel);
            dogModel = this.defaultModel;
        }
        if ((texture_rl = this.pickInjuredTexture(dog, sync_state = dog.getIncapSyncState())) != null) {
            float alpha = this.getInjureOpascity(dog);
            IncapacitatedRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, alpha);
        }
        DogIncapacitatedMananger.BandaidState bandaid_state = sync_state.bandaid;
        ResourceLocation bandaid_texture_rl = null;
        switch (bandaid_state) {
            case FULL: {
                bandaid_texture_rl = Resources.BANDAID_OVERLAY_FULL;
                break;
            }
            case HALF: {
                bandaid_texture_rl = Resources.BANDAID_OVERLAY_HALF;
                break;
            }
        }
        if (bandaid_texture_rl != null) {
            IncapacitatedRenderer.renderTranslucentModel(dogModel, bandaid_texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private ResourceLocation pickInjuredTexture(Dog dog, DogIncapacitatedMananger.IncapacitatedSyncState state) {
        Optional<ResourceLocation> variant_custom_overlay;
        if (dog.isDogVariantRenderEffective() && (variant_custom_overlay = dog.dogVariant().customInjuredTexture()).isPresent()) {
            return null;
        }
        boolean isLowGraphic = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_INCAP_TXT_LESS_GRAPHIC);
        if (isLowGraphic) {
            return Resources.INCAPACITATED_LESS_GRAPHIC;
        }
        DogIncapacitatedMananger.DefeatedType type = state.type;
        ResourceLocation ret = Resources.INCAPACITATED_BLOOD;
        switch (type) {
            case BLOOD: {
                ret = Resources.INCAPACITATED_BLOOD;
                break;
            }
            case BURN: {
                ret = Resources.INCAPACITATED_BURN;
                break;
            }
            case POISON: {
                ret = Resources.INCAPACITATED_POISON;
                break;
            }
            case DROWN: {
                ret = Resources.INCAPACITATED_DROWN;
                break;
            }
            case STARVE: {
                ret = null;
                break;
            }
        }
        return ret;
    }

    private float getInjureOpascity(Dog dog) {
        int default_val = dog.getDefaultInitIncapVal();
        int dog_val = dog.getDogIncapValue();
        if ((float)default_val <= 0.0f) {
            return 0.0f;
        }
        if (dog_val >= default_val) {
            return 1.0f;
        }
        float ret = (float)dog_val / (float)default_val;
        return Mth.m_14036_((float)ret, (float)0.0f, (float)1.0f);
    }

    public static <T extends LivingEntity> void renderTranslucentModel(EntityModel<T> p_117377_, ResourceLocation p_117378_, PoseStack p_117379_, MultiBufferSource p_117380_, int p_117381_, T p_117382_, float p_117383_, float p_117384_, float p_117385_, float opascity) {
        VertexConsumer vertexconsumer = p_117380_.m_6299_(RenderType.m_110473_((ResourceLocation)p_117378_));
        p_117377_.m_7695_(p_117379_, vertexconsumer, p_117381_, LivingEntityRenderer.m_115338_(p_117382_, (float)0.0f), p_117383_, p_117384_, p_117385_, opascity);
    }
}

