/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.FisherDogModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.talent.FisherDogTalent;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class FisherDogRenderer
extends RenderLayer<Dog, DogModel> {
    private FisherDogModel model;

    public FisherDogRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
        this.model = new FisherDogModel(ctx.m_174023_(ClientSetup.DOG_FISHER_HAT));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (dog.m_20145_()) {
            return;
        }
        DogSkin dogSkin = dog.getClientSkin();
        if (dogSkin.useCustomModel() && !(model = dogSkin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        List<AccessoryInstance> accessories = dog.getAccessories();
        for (AccessoryInstance acc : accessories) {
            if (acc.getAccessory().getType() != DoggyAccessoryTypes.HEAD.get()) continue;
            return;
        }
        Optional<FisherDogTalent> inst = dog.getTalent((Supplier)DoggyTalents.FISHER_DOG).map(x -> x.cast(FisherDogTalent.class));
        if (inst.isPresent() && inst.get().canRenderHat() && inst.get().renderHat()) {
            DogModel dogModel = (DogModel)this.m_117386_();
            dogModel.m_102624_(this.model);
            this.model.sync(dogModel);
            RenderLayer.m_117376_((EntityModel)this.model, (ResourceLocation)Resources.FISHER_HAT, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

