/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.DoggyEntityTypes;
import doggytalents.client.entity.render.DogScreenOverlays;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class DTNWolfMountCustomGuiOverlay {
    public static boolean onRenderVehicleHealth(GuiGraphics graphics, ForgeGui gui) {
        if (!DTNWolfMountCustomGuiOverlay.isApplicable()) {
            return false;
        }
        Optional<Entity> vehicle_optional = DTNWolfMountCustomGuiOverlay.getPlayerVehicle();
        if (!vehicle_optional.isPresent()) {
            return false;
        }
        Entity vehicle = vehicle_optional.get();
        if (!DTNWolfMountCustomGuiOverlay.isTargetVehicle(vehicle)) {
            return false;
        }
        if (!(vehicle instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)vehicle;
        int draw_x = graphics.m_280182_() / 2 + 91 - 80;
        int draw_y = graphics.m_280206_() - gui.rightHeight;
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        MutableComponent health_level_str = DTNWolfMountCustomGuiOverlay.getNumberComponent(dog.m_21223_(), dog.m_21233_());
        MutableComponent food_level_str = DTNWolfMountCustomGuiOverlay.getNumberComponent(dog.getDogHunger(), dog.getMaxHunger());
        Optional<Object> air_level_str = Optional.empty();
        boolean render_air = !dog.m_6040_() && (dog.m_204029_(FluidTags.f_13131_) || dog.m_20146_() < dog.m_6062_());
        boolean is_low_air = false;
        if (render_air) {
            float dog_air = dog.m_20146_();
            int dog_air_percent = Mth.m_14167_((float)(dog_air / (float)dog.m_6062_() * 100.0f));
            dog_air_percent = Mth.m_14045_((int)dog_air_percent, (int)0, (int)100);
            air_level_str = Optional.of(Component.m_237113_((String)(Integer.toString(dog_air_percent) + "%")));
            boolean bl = is_low_air = dog_air_percent <= 30;
        }
        if (dog.m_21223_() <= 10.0f) {
            health_level_str = health_level_str.m_130940_(ChatFormatting.RED);
        }
        if (dog.getDogHunger() <= 20.0f) {
            food_level_str = food_level_str.m_130940_(ChatFormatting.RED);
        }
        if (render_air && is_low_air) {
            air_level_str.map(x -> x.m_130940_(ChatFormatting.RED));
        }
        int unit_str_offset = 24;
        int unit_str_yoffset = 1;
        int pX = draw_x;
        int pY = draw_y;
        graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 16, 0, 9, 9);
        graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 52, 0, 9, 9);
        graphics.m_280430_(font, (Component)health_level_str, (pX += 11) + unit_str_offset - font.m_92852_((FormattedText)health_level_str), pY + unit_str_yoffset, -1);
        graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX += 32, pY, 16, 27, 9, 9);
        graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 52, 27, 9, 9);
        graphics.m_280430_(font, (Component)food_level_str, (pX += 11) + unit_str_offset - font.m_92852_((FormattedText)food_level_str), pY + unit_str_yoffset, -1);
        String dog_name_str_0 = dog.m_7755_().getString();
        String dog_name_str = font.m_92895_(dog_name_str_0) > (render_air ? 40 : 67) ? font.m_92834_(dog_name_str_0, render_air ? 36 : 63) + ".." : dog_name_str_0 + ":";
        pX = draw_x;
        graphics.m_280488_(font, dog_name_str, pX, (pY -= 10) + unit_str_yoffset, -1);
        if (air_level_str.isPresent()) {
            pX = draw_x + 43;
            graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 16, 18, 9, 9);
            graphics.m_280430_(font, (Component)air_level_str.get(), (pX += 11) + unit_str_offset - font.m_92852_((FormattedText)air_level_str.get()), pY + unit_str_yoffset, -1);
        }
        gui.rightHeight += 20;
        RenderSystem.disableBlend();
        return true;
    }

    private static MutableComponent getNumberComponent(float val, float max_val) {
        MutableComponent val_str;
        int val_i = Mth.m_14167_((float)val);
        if (val_i > 999 || ((Boolean)ConfigHandler.CLIENT.DTN_WOLF_MOUNT_OVERLAY_PERCENT.get()).booleanValue()) {
            int percent = Mth.m_14167_((float)(val / max_val * 100.0f));
            percent = Mth.m_14045_((int)percent, (int)0, (int)100);
            val_str = Component.m_237113_((String)(Integer.toString(percent) + "%"));
        } else {
            val_str = Component.m_237113_((String)Integer.toString(val_i));
        }
        return val_str;
    }

    public static Optional<Integer> onGetVehicleMaxHearts(LivingEntity vehicle) {
        if (!DTNWolfMountCustomGuiOverlay.isApplicable()) {
            return Optional.empty();
        }
        if (!DTNWolfMountCustomGuiOverlay.isTargetVehicle((Entity)vehicle)) {
            return Optional.empty();
        }
        return Optional.of(20);
    }

    private static Optional<Entity> getPlayerVehicle() {
        Minecraft mc = Minecraft.m_91087_();
        Entity camera_entity = mc.m_91288_();
        if (camera_entity == null) {
            return Optional.empty();
        }
        if (camera_entity.m_6095_() != EntityType.f_20532_) {
            return Optional.empty();
        }
        Entity vehicle = camera_entity.m_20202_();
        if (vehicle == null) {
            return Optional.empty();
        }
        return Optional.of(vehicle);
    }

    private static boolean isTargetVehicle(Entity vehicle) {
        if (vehicle == null) {
            return false;
        }
        if (vehicle.m_6095_() != DoggyEntityTypes.DOG.get()) {
            return false;
        }
        return vehicle.m_20152_();
    }

    public static boolean isApplicable() {
        return (Boolean)ConfigHandler.CLIENT.DTN_WOLF_MOUNT_OVERLAY.get();
    }
}

