/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.friendlygriefing;

import com.black_dog20.friendlygriefing.Config;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="friendlygriefing")
public class FriendlyGriefing {
    public static final String MOD_ID = "friendlygriefing";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("friendlygriefing", "network")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public FriendlyGriefing() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        Config.loadConfig(Config.SERVER_CONFIG, FMLPaths.CONFIGDIR.get().resolve("friendlygriefing-server.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || entity.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return;
        }
        Optional<String> entityId = Optional.of(entity).map(Entity::m_6095_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0)).map(ResourceLocation::toString);
        if (entityId.isPresent() && ((List)Config.FRIENDLY_GRIEFING_MOBS.get()).contains(entityId.get())) {
            event.setResult(Event.Result.ALLOW);
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

