/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.movement;

import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.movement.MovementPluginAction;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.movement.PlayerStateCondition;
import tictim.paraglider.api.movement.StaminaReductionLogic;
import tictim.paraglider.api.plugin.ConflictResolver;
import tictim.paraglider.api.plugin.ParagliderPluginBase;

public interface MovementPlugin
extends ParagliderPluginBase {
    default public void registerNewStates(@NotNull PlayerStateRegister register) {
    }

    default public void modifyRegisteredStates(@NotNull PlayerStateModifier modifier) {
    }

    default public void registerStateConnections(@NotNull PlayerStateConnectionRegister register) {
    }

    default public void registerStaminaReductionLogic(@NotNull StaminaReductionLogicRegister register) {
    }

    @NotNull
    default public ConflictResolver<MovementPlugin, MovementPluginAction> getMovementPluginConflictResolver() {
        return ConflictResolver.proceed();
    }

    public static interface StaminaReductionLogicRegister {
        public void register(@NotNull StaminaReductionLogic var1);
    }

    public static interface PlayerStateConnectionRegister {
        @NotNull
        public @NotNull @Unmodifiable Map<@NotNull ResourceLocation, @NotNull PlayerState> playerStates();

        default public boolean exists(@NotNull ResourceLocation id) {
            return this.playerStates().containsKey(Objects.requireNonNull(id, "id == null"));
        }

        default public void addBranch(@NotNull ResourceLocation parent, @NotNull PlayerStateCondition condition, @NotNull ResourceLocation state) {
            this.addBranch(parent, condition, state, 0.0);
        }

        public void addBranch(@NotNull ResourceLocation var1, @NotNull PlayerStateCondition var2, @NotNull ResourceLocation var3, double var4);

        public void removeBranch(@NotNull ResourceLocation var1, @NotNull ResourceLocation var2, @Nullable Double var3);

        default public void setFallback(@NotNull ResourceLocation parent, @Nullable ResourceLocation fallback) {
            this.setFallback(parent, fallback, 0.0);
        }

        public void setFallback(@NotNull ResourceLocation var1, @Nullable ResourceLocation var2, double var3);
    }

    public static interface PlayerStateModifier {
        @NotNull
        public @NotNull @Unmodifiable Map<@NotNull ResourceLocation, @NotNull PlayerState> playerStates();

        default public boolean exists(@NotNull ResourceLocation id) {
            return this.playerStates().containsKey(Objects.requireNonNull(id, "id == null"));
        }

        public void changeDefaultStaminaDelta(@NotNull ResourceLocation var1, int var2);

        public void addFlags(@NotNull ResourceLocation var1, ResourceLocation ... var2);

        public void removeFlags(@NotNull ResourceLocation var1, ResourceLocation ... var2);
    }

    public static interface PlayerStateRegister {
        public void register(@NotNull ResourceLocation var1, int var2, ResourceLocation ... var3);

        public void registerSyntheticState(@NotNull ResourceLocation var1);
    }
}

