/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.questkilltask.mixin;

import dev.muon.questkilltask.DamageTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void onDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        TamableAnimal tameable;
        LivingEntity victim = (LivingEntity)this;
        if (victim.m_9236_().m_5776_()) {
            return;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DamageTracker.trackDamage(victim, player.m_20148_());
            return;
        }
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof TamableAnimal && (entity2 = (tameable = (TamableAnimal)entity2).m_269323_()) instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity2;
            DamageTracker.trackDamage(victim, owner.m_20148_());
            return;
        }
        if (victim instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)victim;
            entity2 = source.m_7639_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                DamageTracker.trackDamageTaken(attacker, player.m_20148_());
                return;
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/LivingEntity;addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")})
    private void onEffectAdded(MobEffectInstance effectInstance, Entity source, CallbackInfoReturnable<Boolean> cir) {
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer supporter = (ServerPlayer)source;
        LivingEntity target = (LivingEntity)this;
        if (target.m_9236_().m_5776_()) {
            return;
        }
        MobEffect effect = effectInstance.m_19544_();
        boolean isEffectivelyBeneficial = this.isEffectBeneficialForTarget(effect, target);
        if (isEffectivelyBeneficial) {
            DamageTracker.trackHealing(target, supporter.m_20148_());
        } else {
            DamageTracker.trackDamage(target, supporter.m_20148_());
        }
    }

    @Unique
    private boolean isEffectBeneficialForTarget(MobEffect effect, LivingEntity target) {
        boolean isBeneficial = effect.m_19486_();
        if (effect == MobEffects.f_19601_ || effect == MobEffects.f_19602_) {
            isBeneficial = isBeneficial != target.m_21222_();
        }
        return isBeneficial;
    }
}

