/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.questkilltask;

import dev.muon.questkilltask.QuestKillTask;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class DamageTracker {
    private static final Map<LivingEntity, WeakSet<UUID>> DAMAGE_CONTRIBUTORS = new WeakHashMap<LivingEntity, WeakSet<UUID>>();
    private static final Map<LivingEntity, WeakSet<UUID>> DAMAGE_RECEIVERS = new WeakHashMap<LivingEntity, WeakSet<UUID>>();
    private static final Map<LivingEntity, WeakSet<UUID>> HEAL_CONTRIBUTORS = new WeakHashMap<LivingEntity, WeakSet<UUID>>();
    private static final Map<LivingEntity, Long> LAST_INTERACTION_TIME = new WeakHashMap<LivingEntity, Long>();
    private static final long INTERACTION_TIMEOUT = 60000L;
    private static final long CLEANUP_INTERVAL = 30000L;
    private static long lastCleanupTime = 0L;

    public static void trackDamage(LivingEntity victim, UUID contributorId) {
        long currentTime = System.currentTimeMillis();
        DamageTracker.attemptCleanup(currentTime);
        DAMAGE_CONTRIBUTORS.computeIfAbsent(victim, k -> new WeakSet()).add(contributorId);
        LAST_INTERACTION_TIME.put(victim, currentTime);
        QuestKillTask.LOG.debug("Tracked damage from contributor {} to entity {}", (Object)contributorId, (Object)victim);
    }

    public static void trackDamageTaken(LivingEntity attacker, UUID victimId) {
        long currentTime = System.currentTimeMillis();
        DamageTracker.attemptCleanup(currentTime);
        DAMAGE_RECEIVERS.computeIfAbsent(attacker, k -> new WeakSet()).add(victimId);
        LAST_INTERACTION_TIME.put(attacker, currentTime);
        QuestKillTask.LOG.debug("Tracked damage received by {} from entity {}", (Object)victimId, (Object)attacker);
    }

    public static void trackHealing(LivingEntity target, UUID healerId) {
        long currentTime = System.currentTimeMillis();
        DamageTracker.attemptCleanup(currentTime);
        HEAL_CONTRIBUTORS.computeIfAbsent(target, k -> new WeakSet()).add(healerId);
        LAST_INTERACTION_TIME.put(target, currentTime);
        QuestKillTask.LOG.debug("Tracked healing from {} to entity {}", (Object)healerId, (Object)target);
    }

    private static void attemptCleanup(long currentTime) {
        if (currentTime - lastCleanupTime > 30000L) {
            DamageTracker.cleanupTimedOutEntries(currentTime);
            lastCleanupTime = currentTime;
        }
    }

    private static void cleanupTimedOutEntries(long currentTime) {
        Iterator<Map.Entry<LivingEntity, Long>> it = LAST_INTERACTION_TIME.entrySet().iterator();
        int removedCount = 0;
        while (it.hasNext()) {
            Map.Entry<LivingEntity, Long> entry = it.next();
            if (currentTime - entry.getValue() <= 60000L) continue;
            LivingEntity entity = entry.getKey();
            DAMAGE_CONTRIBUTORS.remove(entity);
            DAMAGE_RECEIVERS.remove(entity);
            HEAL_CONTRIBUTORS.remove(entity);
            it.remove();
            ++removedCount;
        }
    }

    public static KillContributors getKillContributors(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return new KillContributors(Set.of(), Set.of(), Set.of());
        }
        long currentTime = System.currentTimeMillis();
        if (LAST_INTERACTION_TIME.getOrDefault(entity, 0L) + 60000L < currentTime) {
            DamageTracker.clearEntityTracking(entity);
            return new KillContributors(Set.of(), Set.of(), Set.of());
        }
        Set<UUID> damagers = DAMAGE_CONTRIBUTORS.getOrDefault(entity, new WeakSet()).toStrongSet();
        Set<UUID> tanks = DAMAGE_RECEIVERS.getOrDefault(entity, new WeakSet()).toStrongSet();
        HashSet<UUID> healers = new HashSet<UUID>();
        WeakSet healerCandidates = HEAL_CONTRIBUTORS.getOrDefault(entity, new WeakSet());
        for (UUID damager : damagers) {
            healers.addAll(healerCandidates.stream().filter(healer -> DamageTracker.hasHealedPlayer(healer, damager)).toList());
        }
        return new KillContributors(damagers, healers, tanks);
    }

    private static boolean hasHealedPlayer(UUID healer, UUID target) {
        return HEAL_CONTRIBUTORS.entrySet().stream().filter(entry -> entry.getKey() instanceof ServerPlayer).filter(entry -> ((ServerPlayer)entry.getKey()).m_20148_().equals(target)).anyMatch(entry -> ((WeakSet)entry.getValue()).contains(healer));
    }

    public static void clearEntityTracking(LivingEntity entity) {
        DAMAGE_CONTRIBUTORS.remove(entity);
        DAMAGE_RECEIVERS.remove(entity);
        HEAL_CONTRIBUTORS.remove(entity);
        LAST_INTERACTION_TIME.remove(entity);
    }

    private static class WeakSet<T>
    extends WeakHashMap<T, Boolean> {
        private WeakSet() {
        }

        public boolean add(T element) {
            return this.put(element, Boolean.TRUE) == null;
        }

        public Set<T> toStrongSet() {
            return new HashSet(this.keySet());
        }

        public boolean contains(Object o) {
            return this.containsKey(o);
        }

        public Stream<T> stream() {
            return this.keySet().stream();
        }
    }

    public record KillContributors(Set<UUID> damagers, Set<UUID> healers, Set<UUID> tanks) {
    }
}

