/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.UnknownNullability;
import team.creative.solonion.api.BenefitCapability;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.benefit.BenefitStack;
import team.creative.solonion.common.benefit.BenefitType;

public class BenefitPlayerDataImpl
implements BenefitCapability {
    private final LazyOptional<BenefitCapability> capabilityOptional = LazyOptional.of(() -> this);
    private HashMap<BenefitType, Object> applied = new HashMap();

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return capability == SOLOnionAPI.BENEFIT_CAP ? this.capabilityOptional.cast() : LazyOptional.empty();
    }

    @Override
    public void updateStack(Player player, BenefitStack benefits) {
        for (BenefitType type : BenefitType.types()) {
            Object app = this.applied.get(type);
            Object stack = benefits.get(type);
            if (app == null) {
                if (stack == null) continue;
                app = type.createApplied();
                this.applied.put(type, app);
            }
            if (!type.apply(player, app, stack)) continue;
            this.applied.remove(type);
        }
    }

    public @UnknownNullability CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<BenefitType, Object> entry : this.applied.entrySet()) {
            Tag tag = entry.getKey().saveApplied(entry.getValue());
            if (tag == null) continue;
            nbt.m_128365_(entry.getKey().getId(), tag);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Map.Entry<BenefitType, Object> entry : this.applied.entrySet()) {
            entry.getKey().clearApplied(entry.getValue());
        }
        if (nbt == null) {
            return;
        }
        for (BenefitType type : BenefitType.types()) {
            if (nbt.m_128441_(type.getId())) {
                Object app = this.applied.get(type);
                if (app == null) {
                    app = type.createApplied();
                    this.applied.put(type, app);
                }
                type.loadApplied(app, nbt.m_128423_(type.getId()));
                continue;
            }
            this.applied.remove(type);
        }
    }

    @Override
    public <T> T getApplied(BenefitType<?, ?, T> type) {
        return (T)this.applied.get(type);
    }
}

