/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectConfig;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.solonion.common.benefit.Benefit;
import team.creative.solonion.common.benefit.BenefitType;
import team.creative.solonion.common.mod.FirstAidManager;

public class BenefitAttribute
extends Benefit<Attribute> {
    public final AttributeModifier.Operation operation;

    public BenefitAttribute(ResourceLocation location, double value, AttributeModifier.Operation op) {
        super(new RegistryObjectConfig(BuiltInRegistries.f_256951_, location), value);
        this.operation = op;
    }

    public BenefitAttribute(Holder<Attribute> holder, double value, AttributeModifier.Operation op) {
        this(((ResourceKey)holder.m_203543_().get()).m_135782_(), value);
    }

    public BenefitAttribute(ResourceLocation location, double value) {
        this(location, value, AttributeModifier.Operation.ADDITION);
    }

    public BenefitAttribute(Holder<Attribute> holder, double value) {
        this(holder, value, AttributeModifier.Operation.ADDITION);
    }

    public BenefitAttribute(Attribute holder, double value) {
        this(BuiltInRegistries.f_256951_.m_7981_((Object)holder), value, AttributeModifier.Operation.ADDITION);
    }

    public BenefitAttribute(CompoundTag nbt) {
        super(BuiltInRegistries.f_256951_, nbt);
        this.operation = AttributeModifier.Operation.values()[nbt.m_128451_("op")];
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = super.save();
        nbt.m_128405_("op", this.operation.ordinal());
        return nbt;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof BenefitAttribute) {
            BenefitAttribute att = (BenefitAttribute)obj;
            return att.operation == this.operation;
        }
        return false;
    }

    private record AttributeHolder(Holder<Attribute> attribute, AttributeModifier.Operation operation) {
    }

    public static class BenefitTypeAttribute
    extends BenefitType<BenefitAttribute, Object2DoubleMap<AttributeHolder>, HashMap<AttributeHolder, AttributeModifier>> {
        public BenefitTypeAttribute(Function<CompoundTag, BenefitAttribute> factory) {
            super(factory);
        }

        @Override
        public Registry registry() {
            return BuiltInRegistries.f_256951_;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, IGuiConfigParent configParent) {
            parent.add((GuiControl)new GuiStateButtonMapped("operation", new TextMapBuilder().addComponent((Object[])AttributeModifier.Operation.values(), x -> Component.m_237115_((String)("config.solonion." + x.name().toLowerCase())))));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void loadValue(BenefitAttribute value, GuiParent parent, IGuiConfigParent configParent) {
            GuiStateButtonMapped op = (GuiStateButtonMapped)parent.get("operation");
            op.select((Object)value.operation);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BenefitAttribute saveValue(ResourceLocation location, double value, GuiParent parent, IGuiConfigParent configParent) {
            GuiStateButtonMapped op = (GuiStateButtonMapped)parent.get("operation");
            return new BenefitAttribute(location, value, (AttributeModifier.Operation)op.getSelected());
        }

        @Override
        public Object2DoubleMap<AttributeHolder> createStack() {
            return new Object2DoubleArrayMap();
        }

        @Override
        public void addToStack(BenefitAttribute value, Object2DoubleMap<AttributeHolder> stack) {
            stack.compute((Object)new AttributeHolder((Holder<Attribute>)value.property.getHolder(), value.operation), (x, y) -> y != null ? Math.max(y, value.value) : value.value);
        }

        @Override
        public boolean isEmpty(Object2DoubleMap<AttributeHolder> stack) {
            return stack.isEmpty();
        }

        @Override
        public HashMap<AttributeHolder, AttributeModifier> createApplied() {
            return new HashMap<AttributeHolder, AttributeModifier>();
        }

        @Override
        public void clearApplied(HashMap<AttributeHolder, AttributeModifier> applied) {
            applied.clear();
        }

        @Override
        public Tag saveApplied(HashMap<AttributeHolder, AttributeModifier> applied) {
            ListTag list = new ListTag();
            for (Map.Entry<AttributeHolder, AttributeModifier> entry : applied.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("att", ((ResourceKey)entry.getKey().attribute.m_203543_().get()).m_135782_().toString());
                tag.m_128405_("op", entry.getKey().operation.ordinal());
                tag.m_128365_("mod", (Tag)entry.getValue().m_22219_());
                list.add((Object)tag);
            }
            return list;
        }

        @Override
        public void loadApplied(HashMap<AttributeHolder, AttributeModifier> applied, Tag nbt) {
            if (nbt instanceof ListTag) {
                ListTag list = (ListTag)nbt;
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    Holder.Reference att = (Holder.Reference)BuiltInRegistries.f_256951_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256728_, (ResourceLocation)new ResourceLocation(tag.m_128461_("att")))).get();
                    if (att == null) continue;
                    applied.put(new AttributeHolder((Holder<Attribute>)att, AttributeModifier.Operation.values()[tag.m_128451_("op")]), AttributeModifier.m_22212_((CompoundTag)tag.m_128469_("mod")));
                }
            }
        }

        @Override
        public boolean apply(Player player, HashMap<AttributeHolder, AttributeModifier> applied, @Nullable Object2DoubleMap<AttributeHolder> stack) {
            if (!applied.isEmpty()) {
                for (Map.Entry entry : applied.entrySet()) {
                    player.m_21051_((Attribute)((AttributeHolder)entry.getKey()).attribute.get()).m_22120_(((AttributeModifier)entry.getValue()).m_22209_());
                }
                applied.clear();
            }
            if (stack != null) {
                for (Object2DoubleMap.Entry entry : stack.object2DoubleEntrySet()) {
                    AttributeModifier modi = new AttributeModifier("solonion:" + ((AttributeHolder)entry.getKey()).operation.toString().toLowerCase(), entry.getDoubleValue(), ((AttributeHolder)entry.getKey()).operation);
                    AttributeInstance att = player.m_21051_((Attribute)((AttributeHolder)entry.getKey()).attribute.get());
                    if (att == null) continue;
                    float oldMax = player.m_21233_();
                    att.m_22125_(modi);
                    applied.put((AttributeHolder)entry.getKey(), modi);
                    if (((AttributeHolder)entry.getKey()).attribute != Attributes.f_22276_ || FirstAidManager.INSTALLED) continue;
                    float newHealth = player.m_21223_() * player.m_21233_() / oldMax;
                    player.m_21153_(newHealth);
                }
            }
            return applied.isEmpty();
        }
    }
}

