/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.annotation;

import info.u_team.u_team_core.util.ServiceUtil;
import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

public class AnnotationUtil {
    private static final AnnotationScanner SCANNER = ServiceUtil.loadOne(AnnotationScanner.class);

    public static List<AnnotationData> getAnnotations(String modid, Type type) {
        return AnnotationUtil.getAnnotations(modid).stream().filter(data -> type.equals((Object)data.annotationType())).collect(Collectors.toList());
    }

    public static List<AnnotationData> getAnnotations(String modid) {
        return SCANNER.findAnnotations(modid);
    }

    public static interface AnnotationScanner {
        public List<AnnotationData> findAnnotations(String var1);
    }

    public record AnnotationData(Type annotationType, ElementType targetType, Type clazz, String memberName, Map<String, Object> annotationData) {
    }
}

