/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.annotation;

import com.mojang.logging.LogUtils;
import info.u_team.u_team_core.api.Platform;
import info.u_team.u_team_core.api.construct.Construct;
import info.u_team.u_team_core.api.construct.ModConstruct;
import info.u_team.u_team_core.api.integration.Integration;
import info.u_team.u_team_core.api.integration.ModIntegration;
import info.u_team.u_team_core.util.annotation.AnnotationUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AnnotationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker CONSTRUCT_MARKER = MarkerFactory.getMarker((String)"Construct");
    private static final Marker INTEGRATION_MARKER = MarkerFactory.getMarker((String)"Integration");

    public static void callAnnotations(String modid) {
        AnnotationManager.callConstructs(modid);
        AnnotationManager.callIntegrations(modid);
    }

    public static void callConstructs(String modid) {
        ArrayList<AnnotationUtil.AnnotationData> callable = new ArrayList<AnnotationUtil.AnnotationData>();
        for (AnnotationUtil.AnnotationData data : AnnotationUtil.getAnnotations(modid, Type.getType(Construct.class))) {
            if (!AnnotationManager.canBeCalled(modid, data)) continue;
            callable.add(data);
        }
        callable.sort(AnnotationManager.sortByPriority());
        for (AnnotationUtil.AnnotationData data : callable) {
            LOGGER.debug(CONSTRUCT_MARKER, "Load construct (" + data.memberName() + ") for mod " + modid);
            try {
                Class.forName(data.memberName()).asSubclass(ModConstruct.class).getConstructor(new Class[0]).newInstance(new Object[0]).construct();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | LinkageError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                LOGGER.error(CONSTRUCT_MARKER, "Failed to load and call mod construct : {}", (Object)data.memberName(), (Object)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public static void callIntegrations(String modid) {
        ArrayList<AnnotationUtil.AnnotationData> callable = new ArrayList<AnnotationUtil.AnnotationData>();
        for (AnnotationUtil.AnnotationData data : AnnotationUtil.getAnnotations(modid, Type.getType(Integration.class))) {
            if (!AnnotationManager.canBeCalled(modid, data) || !Platform.getInstance().isModLoaded((String)data.annotationData().get("integration"))) continue;
            callable.add(data);
        }
        callable.sort(AnnotationManager.sortByPriority());
        for (AnnotationUtil.AnnotationData data : callable) {
            LOGGER.debug(INTEGRATION_MARKER, "Load " + String.valueOf(data.annotationData().get("integration")) + " integration (" + data.memberName() + ") for mod " + modid);
            try {
                Class.forName(data.memberName()).asSubclass(ModIntegration.class).getConstructor(new Class[0]).newInstance(new Object[0]).construct();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | LinkageError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                LOGGER.error(INTEGRATION_MARKER, "Failed to load and call integration : {}", (Object)data.memberName(), (Object)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private static boolean canBeCalled(String modid, AnnotationUtil.AnnotationData data) {
        String annotationModid = (String)data.annotationData().get("modid");
        Boolean client = (Boolean)data.annotationData().get("client");
        return modid.equals(annotationModid) && (client == null || client == false || client != false && Platform.getInstance().getEnvironment() == Platform.Environment.CLIENT);
    }

    private static Comparator<AnnotationUtil.AnnotationData> sortByPriority() {
        Function<AnnotationUtil.AnnotationData, Pair> resolver = data -> {
            Integer priority;
            Boolean client = (Boolean)data.annotationData().get("client");
            if (client == null) {
                client = false;
            }
            if ((priority = (Integer)data.annotationData().get("priority")) == null) {
                priority = 1000;
            }
            return Pair.of((Object)client, (Object)priority);
        };
        return (first, second) -> {
            Pair firstData = (Pair)resolver.apply((AnnotationUtil.AnnotationData)first);
            Pair secondData = (Pair)resolver.apply((AnnotationUtil.AnnotationData)second);
            return firstData.compareTo(secondData);
        };
    }
}

