/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import info.u_team.u_team_core.gui.renderer.FluidInventoryRenderer;
import info.u_team.u_team_core.intern.init.UCoreNetworkForge;
import info.u_team.u_team_core.intern.network.FluidClickContainerMessage;
import info.u_team.u_team_core.menu.FluidContainerMenu;
import info.u_team.u_team_core.menu.FluidSlot;
import info.u_team.u_team_core.menu.ForgeFluidContainerMenuDelegator;
import info.u_team.u_team_core.screen.FluidContainerMenuScreen;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeFluidContainerMenuScreenDelegator<T extends AbstractContainerMenu>
implements FluidContainerMenuScreen.FluidContainerScreenDelegator {
    private final FluidContainerMenuScreen<T> screen;
    protected FluidInventoryRenderer fluidRenderer = FluidInventoryRenderer.DEFAULT_INSTANCE;
    protected FluidSlot hoveredFluidSlot;

    ForgeFluidContainerMenuScreenDelegator(FluidContainerMenuScreen<T> screen) {
        this.screen = screen;
    }

    public void setFluidRenderer(FluidInventoryRenderer fluidRenderer) {
        this.fluidRenderer = fluidRenderer;
    }

    @Override
    public void renderLabels(GuiGraphics guiGrapics, int mouseX, int mouseY) {
        AbstractContainerMenu abstractContainerMenu = this.screen.m_6262_();
        if (abstractContainerMenu instanceof FluidContainerMenu) {
            FluidContainerMenu fluidMenu = (FluidContainerMenu)abstractContainerMenu;
            this.hoveredFluidSlot = null;
            for (int slot = 0; slot < ((ForgeFluidContainerMenuDelegator)fluidMenu.getDelegator()).fluidSlots.size(); ++slot) {
                FluidSlot fluidSlot = ((ForgeFluidContainerMenuDelegator)fluidMenu.getDelegator()).fluidSlots.get(slot);
                if (!fluidSlot.isActive()) continue;
                this.renderFluidSlot(guiGrapics, fluidSlot);
                if (!this.isHovering(fluidSlot, mouseX, mouseY)) continue;
                this.hoveredFluidSlot = fluidSlot;
                RenderUtil.setShaderColor(RGBA.WHITE);
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGrapics, (int)fluidSlot.getX(), (int)fluidSlot.getY(), (int)0, (int)this.getFluidSlotColor(slot));
            }
        }
    }

    protected void renderFluidSlot(GuiGraphics guiGrapics, FluidSlot fluidSlot) {
        Pair<ResourceLocation, ResourceLocation> pair;
        PoseStack poseStack = guiGrapics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        int x = fluidSlot.getX();
        int y = fluidSlot.getY();
        if (!fluidSlot.hasFluid() && fluidSlot.isActive() && (pair = fluidSlot.getNoItemIcon()) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.screen.getMinecraft().m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderUtil.drawTexturedQuad(poseStack, x, y, 16, 16, 0.0f, sprite, RGBA.WHITE);
        }
        this.fluidRenderer.drawFluidInSlot(poseStack, x, y, 0.0f, fluidSlot.getFluid());
        poseStack.m_85849_();
    }

    @Override
    public void renderTooltip(GuiGraphics guiGrapics, int mouseX, int mouseY) {
        if (this.screen.m_6262_().m_142621_().m_41619_() && this.hoveredFluidSlot != null && this.hoveredFluidSlot.hasFluid()) {
            guiGrapics.m_280666_(Minecraft.m_91087_().f_91062_, this.getTooltipFromFluid(this.hoveredFluidSlot), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        FluidSlot fluidSlot;
        if (button == 0 && (fluidSlot = this.findFluidSlot(mouseX, mouseY)) != null) {
            if (!this.screen.m_6262_().m_142621_().m_41619_()) {
                UCoreNetworkForge.NETWORK.sendToServer((Object)new FluidClickContainerMessage(this.screen.m_6262_().f_38840_, fluidSlot.index, Screen.m_96638_(), this.screen.m_6262_().m_142621_()));
            }
            return true;
        }
        return false;
    }

    protected FluidSlot findFluidSlot(double mouseX, double mouseY) {
        AbstractContainerMenu abstractContainerMenu = this.screen.m_6262_();
        if (abstractContainerMenu instanceof FluidContainerMenu) {
            FluidContainerMenu fluidMenu = (FluidContainerMenu)abstractContainerMenu;
            for (FluidSlot fluidSlot : ((ForgeFluidContainerMenuDelegator)fluidMenu.getDelegator()).fluidSlots) {
                if (!this.isHovering(fluidSlot, mouseX, mouseY) || !fluidSlot.isActive()) continue;
                return fluidSlot;
            }
        }
        return null;
    }

    protected boolean isHovering(FluidSlot fluidSlot, double mouseX, double mouseY) {
        return this.screen.m_6774_(fluidSlot.getX(), fluidSlot.getY(), 16, 16, mouseX, mouseY);
    }

    protected int getFluidSlotColor(int index) {
        return this.screen.getSlotColor(index);
    }

    public List<Component> getTooltipFromFluid(FluidSlot fluidSlot) {
        FluidStack stack = fluidSlot.getFluid();
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(stack.getDisplayName());
        list.add((Component)Component.m_237113_((String)(stack.getAmount() + " mb/" + fluidSlot.getSlotCapacity() + " mb")).m_130940_(ChatFormatting.GRAY));
        if (this.screen.getMinecraft().f_91066_.f_92125_) {
            list.add((Component)Component.m_237113_((String)ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return list;
    }

    public static class Factory
    implements FluidContainerMenuScreen.FluidContainerScreenDelegator.Factory {
        @Override
        public <T extends AbstractContainerMenu> FluidContainerMenuScreen.FluidContainerScreenDelegator create(FluidContainerMenuScreen<T> menu) {
            return new ForgeFluidContainerMenuScreenDelegator<T>(menu);
        }
    }
}

