/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.block;

import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.MenuUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface EntityBlockProvider
extends EntityBlock {
    public BlockEntityType<?> blockEntityType(BlockPos var1, BlockState var2);

    default public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        BlockEntityType<?> type = this.blockEntityType(pos, state);
        if (type != null) {
            return type.m_155264_(pos, state);
        }
        return null;
    }

    default public <T extends BlockEntity> Optional<T> getBlockEntity(BlockGetter level, BlockPos pos) {
        return this.getMatchingBlockEntity(level, pos);
    }

    default public InteractionResult openMenu(Level level, BlockPos pos, Player player) {
        return this.openMenu(level, pos, player, false);
    }

    default public InteractionResult openMenu(Level level, BlockPos pos, Player player, boolean canOpenWhenSecondaryUse) {
        if (level.m_5776_() || !(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Optional blockEntityOptional = this.getBlockEntity((BlockGetter)level, pos);
        if (!blockEntityOptional.isPresent()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = (BlockEntity)blockEntityOptional.get();
        if (!(blockEntity instanceof MenuProvider)) {
            return InteractionResult.PASS;
        }
        MenuProvider menuProvider = (MenuProvider)blockEntity;
        if (!canOpenWhenSecondaryUse && serverPlayer.m_36341_()) {
            return InteractionResult.SUCCESS;
        }
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        if (blockEntity instanceof MenuSyncedBlockEntity) {
            MenuSyncedBlockEntity syncedBlockEntity = (MenuSyncedBlockEntity)blockEntity;
            syncedBlockEntity.sendInitialMenuDataToClient(data);
        }
        MenuUtil.openMenu(serverPlayer, menuProvider, byteBuf -> {
            byteBuf.m_130064_(pos);
            byteBuf.m_130130_(data.readableBytes());
            byteBuf.writeBytes((ByteBuf)data);
            data.release();
        }, false);
        return InteractionResult.SUCCESS;
    }

    private <T extends BlockEntity> Optional<T> getMatchingBlockEntity(BlockGetter level, BlockPos pos) {
        return (Optional)CastUtil.uncheckedCast(level.m_141902_(pos, this.blockEntityType(pos, level.m_8055_(pos))));
    }
}

