/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.Respawn;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureData {
    public static final StructureData EMPTY = new StructureData(BlockPos.f_121853_, new ResourceLocation("dummy"));
    private static final int DATA_VERSION = 1;
    public final SectionPos pos;
    public final ResourceLocation id;
    private StructureStart structureStart = null;
    public int bbSize = 0;
    public boolean disabledRespawn = false;
    public int spawnerActivations = 0;
    public int spawnerBreak = 0;
    public int containerLooted = 0;
    public int lightsPlaced = 0;
    public int redstonePlaced = 0;
    public int blocksPlaced = 0;
    public int blocksBroken = 0;
    public int mobsKilled = 0;
    public int playerDeaths = 0;
    public int portalUsage = 0;
    public int blockEntities = 0;
    public long inhabitedStart = 0L;
    public long lastActivity = 0L;
    public int respawns = 0;

    public StructureData(BlockPos pos, ResourceLocation id) {
        this.pos = SectionPos.m_123199_((BlockPos)pos);
        this.id = id;
    }

    public void setLastModifiedTime(long timepoint) {
        this.lastActivity = timepoint;
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("version", 1);
        tag.m_128405_("posx", this.pos.m_123341_());
        tag.m_128405_("posy", this.pos.m_123342_());
        tag.m_128405_("posz", this.pos.m_123343_());
        tag.m_128359_("id", this.id.toString());
        tag.m_128379_("disabledRespawn", this.disabledRespawn);
        tag.m_128405_("spawnerActivations", this.spawnerActivations);
        tag.m_128405_("bbSize", this.bbSize);
        tag.m_128405_("spawnerBreak", this.spawnerBreak);
        tag.m_128405_("portalUsage", this.portalUsage);
        tag.m_128405_("containerLooted", this.containerLooted);
        tag.m_128405_("lightsPlaced", this.lightsPlaced);
        tag.m_128405_("redstonePlaced", this.redstonePlaced);
        tag.m_128405_("blockEntities", this.blockEntities);
        tag.m_128356_("inhabitedStart", this.inhabitedStart);
        tag.m_128405_("blocksPlaced", this.blocksPlaced);
        tag.m_128405_("blocksBroken", this.blocksBroken);
        tag.m_128405_("mobsKilled", this.mobsKilled);
        tag.m_128405_("playerDeaths", this.playerDeaths);
        tag.m_128405_("respawns", this.respawns);
        tag.m_128356_("lastActivity", this.lastActivity);
        return tag;
    }

    public StructureData(CompoundTag tag) {
        int version = tag.m_128451_("version");
        this.pos = SectionPos.m_123173_((int)tag.m_128451_("posx"), (int)tag.m_128451_("posy"), (int)tag.m_128451_("posz"));
        this.id = ResourceLocation.m_135820_((String)tag.m_128461_("id"));
        this.spawnerActivations = tag.m_128451_("spawnerActivations");
        this.bbSize = tag.m_128451_("bbSize");
        this.disabledRespawn = tag.m_128471_("disabledRespawn");
        this.spawnerBreak = tag.m_128451_("spawnerBreak");
        this.portalUsage = tag.m_128451_("portalUsage");
        this.containerLooted = tag.m_128451_("containerLooted");
        this.lightsPlaced = tag.m_128451_("lightsPlaced");
        if (tag.m_128441_("redstonePlaced")) {
            this.redstonePlaced = tag.m_128451_("redstonePlaced");
        }
        if (tag.m_128441_("blockEntities")) {
            this.blockEntities = tag.m_128451_("blockEntities");
        }
        if (tag.m_128441_("inhabitedStart")) {
            this.inhabitedStart = tag.m_128454_("inhabitedStart");
        }
        this.blocksPlaced = tag.m_128451_("blocksPlaced");
        this.blocksBroken = tag.m_128451_("blocksBroken");
        this.mobsKilled = tag.m_128451_("mobsKilled");
        this.playerDeaths = tag.m_128451_("playerDeaths");
        this.respawns = tag.m_128451_("respawns");
        this.lastActivity = tag.m_128454_("lastActivity");
    }

    public StructureStart fillStructureStart(ServerLevel level) {
        if (this.structureStart != null) {
            return this.structureStart;
        }
        for (Map.Entry entry : level.m_215010_().m_220522_(this.pos.m_123250_()).entrySet()) {
            if (!this.id.equals((Object)((Registry)level.m_9598_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)((Structure)entry.getKey())))) continue;
            level.m_215010_().m_220480_((Structure)entry.getKey(), (LongSet)entry.getValue(), structureStart -> {
                if (SectionPos.m_123199_((BlockPos)structureStart.m_73601_().m_162394_()).equals((Object)this.pos)) {
                    this.structureStart = structureStart;
                }
            });
        }
        if (this.structureStart == null) {
            RespawningStructures.LOGGER.warn("Structure: " + this.id + " could not be found, disabling respawn");
            this.disabledRespawn = true;
        }
        return this.structureStart;
    }

    public boolean respawn(ServerLevel level) {
        if (this.canRespawn(level) == RespawnStatus.PENDING_RESPAWN) {
            try {
                return RespawnManager.respawnStructure(level, this, true);
            }
            catch (Exception e) {
                RespawningStructures.LOGGER.warn("Error during respawning structure: " + this.id + " blacklisting structure type", (Throwable)e);
                ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.add(this.id.toString());
                RespawningStructures.config.save();
            }
        }
        return false;
    }

    public RespawnStatus canRespawn(ServerLevel level) {
        if (!((CommonConfiguration)RespawningStructures.config.getCommonConfig()).enableAutomaticRespawn || this.disabledRespawn) {
            return RespawnStatus.RESPAWN_DISABLED;
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).whitelist && !((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.contains(this.id.toString()) || !((CommonConfiguration)RespawningStructures.config.getCommonConfig()).whitelist && ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.contains(this.id.toString())) {
            return RespawnStatus.BLACKLISTED;
        }
        if (this.lastActivity == 0L || ((RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata")).getLevelTime() - this.lastActivity < (long)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).minutesUntilRespawn * 60L) {
            if (this.lastActivity == 0L) {
                return RespawnStatus.UNUSED;
            }
            return RespawnStatus.WAITING_RESPAWN_TIME;
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).respawnableStructureIDs.contains(this.id.toString())) {
            return this.checkStats(level);
        }
        RespawnStatus status = this.checkBlockingStats(level);
        if (status.isBlocked()) {
            return status;
        }
        status = this.checkStats(level);
        if (status == RespawnStatus.PENDING_RESPAWN) {
            ChunkAccess chunk;
            RespawnLevelData levelData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
            Iterator<Respawn> iterator = levelData.playerRespawnTracker.values().iterator();
            while (iterator.hasNext()) {
                Respawn respawnData = iterator.next();
                BlockPos center = this.pos.m_123250_();
                if (StructureData.dist2D(respawnData.position, center) < ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).playerRespawnDist && levelData.getLevelTime() - respawnData.lastUsageLevelTime < 1814400L) {
                    this.lastActivity = levelData.getLevelTime() - (long)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).minutesUntilRespawn * 60L / 2L;
                    return RespawnStatus.BLOCKED_PORTAL;
                }
                if (levelData.getLevelTime() - respawnData.lastUsageLevelTime <= 1987200L) continue;
                iterator.remove();
            }
            if (this.inhabitedStart != 0L && level.m_46749_(this.pos.m_123249_()) && (double)((chunk = level.m_46865_(this.pos.m_123249_())).m_6319_() - this.inhabitedStart) / 20.0 / (double)(levelData.getLevelTime() - 60L - this.lastActivity) > (double)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).playerNearbyTime / 100.0) {
                this.lastActivity = levelData.getLevelTime();
                this.inhabitedStart = chunk.m_6319_();
                return RespawnStatus.BLOCKED_PORTAL;
            }
        }
        return status;
    }

    public RespawnStatus checkStats(ServerLevel level) {
        if (this.spawnerBreak > 0) {
            return RespawnStatus.PENDING_RESPAWN;
        }
        if (this.containerLooted > 0) {
            return RespawnStatus.PENDING_RESPAWN;
        }
        if (this.spawnerActivations * 3 + this.lightsPlaced * 3 + this.blocksPlaced + this.blocksBroken + this.mobsKilled * 4 + this.playerDeaths * 10 > 25 - (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).respawnableStructureIDs.contains(this.id.toString()) ? 15 : 0)) {
            return RespawnStatus.PENDING_RESPAWN;
        }
        return RespawnStatus.UNUSED;
    }

    public RespawnStatus checkBlockingStats(ServerLevel level) {
        if (this.portalUsage > 5) {
            return RespawnStatus.BLOCKED_PORTAL;
        }
        if ((double)this.redstonePlaced * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod > 10.0) {
            return RespawnStatus.BLOCKED_REDSTONEPLACED;
        }
        if (this.blockEntities > 10) {
            return RespawnStatus.BLOCKED_FOUND_BLOCKENTITIES;
        }
        if ((double)this.blocksBroken * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod / (double)this.bbSize > 0.15) {
            return RespawnStatus.BLOCKED_BROKENBLOCKS;
        }
        if ((double)this.blocksPlaced * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod > 200.0 + (double)this.bbSize / 10000.0 && (double)this.blocksBroken * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod > 200.0 + (double)this.bbSize / 100000.0) {
            RespawnLevelData levelData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
            if (levelData.getLevelTime() - this.lastActivity > 5184000L && level.m_46749_(this.pos.m_123250_())) {
                this.blocksPlaced = (int)((double)this.blocksPlaced * 0.99);
                this.blocksBroken = (int)((double)this.blocksBroken * 0.99);
            }
            return RespawnStatus.BLOCKED_PLACEDBROKENBLOCKS;
        }
        return RespawnStatus.PENDING_RESPAWN;
    }

    public StructureStart getStructureStart() {
        return this.structureStart;
    }

    public void setStructureStart(StructureStart structureStart) {
        Vec3i length = structureStart.m_73601_().m_71053_();
        this.bbSize = length.m_123341_() * length.m_123342_() * length.m_123343_();
        this.structureStart = structureStart;
    }

    public void onRespawnReset() {
        ++this.respawns;
        this.spawnerActivations = 0;
        this.spawnerBreak = 0;
        this.containerLooted = 0;
        this.lightsPlaced = 0;
        this.redstonePlaced = 0;
        this.blocksPlaced = 0;
        this.blocksBroken = 0;
        this.mobsKilled = 0;
        this.playerDeaths = 0;
        this.portalUsage = 0;
        this.blockEntities = 0;
        this.inhabitedStart = 0L;
        this.lastActivity = 0L;
    }

    public Component getStats(ServerLevel level) {
        int dist = Integer.MAX_VALUE;
        RespawnLevelData levelData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        Iterator<Respawn> iterator = levelData.playerRespawnTracker.values().iterator();
        while (iterator.hasNext()) {
            Respawn respawnData = iterator.next();
            BlockPos center = this.pos.m_123250_();
            if (levelData.getLevelTime() - respawnData.lastUsageLevelTime < 1814400L && StructureData.dist2D(respawnData.position, center) < dist) {
                dist = StructureData.dist2D(respawnData.position, center);
            }
            if (levelData.getLevelTime() - respawnData.lastUsageLevelTime <= 1987200L) continue;
            iterator.remove();
        }
        int inhabitedTimePct = 0;
        if (this.inhabitedStart != 0L) {
            ChunkAccess chunk = level.m_46865_(this.pos.m_123249_());
            inhabitedTimePct = (int)((double)(chunk.m_6319_() - this.inhabitedStart) / 20.0 / (double)(levelData.getLevelTime() - 60L - this.lastActivity) * 100.0);
        }
        return Component.m_237113_((String)("Broken blocks: " + this.blocksBroken)).m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(" Placed blocks: " + this.blocksPlaced)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" lights placed: " + this.lightsPlaced)).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)(" redstone placed: " + this.redstonePlaced)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" blockentities : " + this.blockEntities)).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)(" Portal usage: " + this.portalUsage)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" Containers looted: " + this.containerLooted)).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)(" Mobs killed: " + this.mobsKilled)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" Player deaths: " + this.playerDeaths)).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)(" Spawner broken: " + this.spawnerBreak)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" Nearest player spawn: " + dist)).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)(" Inhabited time pct: " + inhabitedTimePct)).m_130940_(ChatFormatting.WHITE));
    }

    public static int dist2D(BlockPos pos, BlockPos pos2) {
        int xDiff = pos.m_123341_() - pos2.m_123341_();
        int zDiff = pos.m_123343_() - pos2.m_123343_();
        return (int)Math.sqrt(xDiff * xDiff + zDiff * zDiff);
    }

    public static enum RespawnStatus {
        UNUSED,
        RESPAWN_DISABLED(true),
        PENDING_RESPAWN,
        BLOCKED_PORTAL(true),
        BLOCKED_PLACEDBROKENBLOCKS(true),
        BLOCKED_BROKENBLOCKS(true),
        BLOCKED_REDSTONEPLACED(true),
        BLACKLISTED(true),
        WAITING_RESPAWN_TIME,
        BLOCKED_FOUND_BLOCKENTITIES(true);

        private final boolean isBLocked;

        private RespawnStatus() {
            this.isBLocked = false;
        }

        private RespawnStatus(boolean blocked) {
            this.isBLocked = blocked;
        }

        public boolean isBlocked() {
            return this.isBLocked;
        }
    }
}

