/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.IRemembersPositionPiece;
import com.respawningstructures.structure.Respawn;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.StructureData;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.levelgen.structure.structures.JungleTemplePiece;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressPieces;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdPieces;
import net.minecraft.world.phys.AABB;

public class RespawnManager {
    public static volatile StructureData respawnInProgress = null;
    public static Object2IntOpenHashMap<EntityType> entityCounts = new Object2IntOpenHashMap();
    public static Object2IntOpenHashMap<BlockPos> heightMap = null;
    public static TicketType<ChunkPos> RESPAWN_TICKET = TicketType.m_9465_((String)"respawningstructures", Comparator.comparingLong(ChunkPos::m_45588_), (int)1200);
    private static List<MobEffect> randomEffects = List.of(MobEffects.f_19606_, MobEffects.f_19607_, MobEffects.f_19605_, MobEffects.f_19600_, MobEffects.f_19608_, MobEffects.f_19617_, MobEffects.f_216964_, MobEffects.f_19603_);

    public static StructureData getForPos(ServerLevel level, BlockPos pos, boolean update) {
        RespawnLevelData respawnData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        return respawnData.getForPos(level, pos, update);
    }

    public static void onSpawnerKilled(SpawnerBlockEntity entity) {
        StructureData structureData;
        if (entity.m_58898_() && !entity.m_58904_().m_5776_() && (structureData = RespawnManager.getForPos((ServerLevel)entity.m_58904_(), entity.m_58899_(), true)) != null) {
            ++structureData.spawnerBreak;
        }
    }

    public static void onSpawnerActive(ServerLevel level, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos(level, pos, true);
        if (structureData != null) {
            ++structureData.spawnerActivations;
        }
    }

    public static void onChestLooted(ServerLevel level, ResourceLocation lootTable, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos(level, pos, true);
        if (structureData != null) {
            ++structureData.containerLooted;
        }
    }

    public static void onBlockEntityAddRemove(ServerLevel level, BlockPos pos, boolean remove) {
        StructureData structureData = RespawnManager.getForPos(level, pos, false);
        if (structureData != null) {
            if (!remove) {
                structureData.setLastModifiedTime(structureData.lastActivity + 200L);
                ++structureData.blockEntities;
            } else {
                structureData.blockEntities = Math.max(0, structureData.blockEntities - 1);
            }
        }
    }

    public static void onMobKilled(LivingEntity entity) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)entity.m_9236_(), entity.m_20183_(), true);
        if (structureData != null) {
            ++structureData.mobsKilled;
            if (entity.m_21233_() > 80.0f) {
                structureData.mobsKilled += 10;
            }
        }
    }

    public static void onBlockBreak(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.blocksBroken;
        }
    }

    public static void onLightPlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.lightsPlaced;
        }
    }

    public static void onRedstonePlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.redstonePlaced;
        }
    }

    public static void onRedstoneDestroyed(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            structureData.redstonePlaced = Math.max(0, structureData.redstonePlaced - 1);
        }
    }

    public static void onBlockPlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.blocksPlaced;
        }
    }

    public static void onExplosion(Level level, Explosion explosion, List<BlockPos> affectedBlocks) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)level, BlockPos.m_274446_((Position)explosion.getPosition()), true);
        if (structureData != null) {
            structureData.blocksBroken += affectedBlocks.size() / 2;
        }
    }

    public static void onPlayerDeath(ServerPlayer player) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), player.m_20183_(), true);
        if (structureData != null) {
            ++structureData.playerDeaths;
        }
    }

    public static void onPlayerLogin(ServerPlayer entity) {
        RespawnLevelData levelData = (RespawnLevelData)((ServerLevel)entity.m_9236_()).m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        if (entity.m_8961_() != null && entity.m_9236_().m_46472_() == entity.m_8963_()) {
            levelData.playerRespawnTracker.computeIfAbsent((UUID)entity.m_20148_(), (Function<UUID, Respawn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onPlayerLogin$0(net.minecraft.server.level.ServerPlayer com.respawningstructures.structure.RespawnLevelData java.util.UUID ), (Ljava/util/UUID;)Lcom/respawningstructures/structure/Respawn;)((ServerPlayer)entity, (RespawnLevelData)levelData)).lastUsageLevelTime = levelData.getLevelTime();
        }
        levelData.m_77762_();
    }

    public static void onPlayerRespawn(ServerPlayer entity) {
        RespawnLevelData levelData = (RespawnLevelData)((ServerLevel)entity.m_9236_()).m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        if (entity.m_8961_() != null && entity.m_9236_().m_46472_() == entity.m_8963_()) {
            levelData.playerRespawnTracker.computeIfAbsent((UUID)entity.m_20148_(), (Function<UUID, Respawn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onPlayerRespawn$1(net.minecraft.server.level.ServerPlayer com.respawningstructures.structure.RespawnLevelData java.util.UUID ), (Ljava/util/UUID;)Lcom/respawningstructures/structure/Respawn;)((ServerPlayer)entity, (RespawnLevelData)levelData)).lastUsageLevelTime = levelData.getLevelTime();
        }
        levelData.m_77762_();
    }

    public static void onPlayerSetSpawn(ServerPlayer entity) {
        for (ServerLevel level : entity.f_8924_.m_129785_()) {
            RespawnLevelData levelData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
            Respawn respawn = levelData.playerRespawnTracker.get(entity.m_20148_());
            if (respawn == null) {
                if (level.m_46472_() == entity.m_8963_() && entity.m_8961_() != null) {
                    levelData.playerRespawnTracker.computeIfAbsent(entity.m_20148_(), uuid -> new Respawn((UUID)uuid, entity.m_8961_(), levelData.getLevelTime()));
                }
            } else if (level.m_46472_() != entity.m_8963_()) {
                levelData.playerRespawnTracker.remove(entity.m_20148_());
            } else {
                respawn.lastUsageLevelTime = levelData.getLevelTime();
            }
            levelData.m_77762_();
        }
    }

    public static void onPortalUsage(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.portalUsage;
        }
    }

    public static void onLevelTick(ServerLevel level) {
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).dimensionBlackList.contains(level.m_46472_().m_135782_().toString())) {
            return;
        }
        RespawnLevelData respawnData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        for (StructureData data : respawnData.getAllStructureData()) {
            if (data.canRespawn(level) == StructureData.RespawnStatus.PENDING_RESPAWN && data.respawn(level)) break;
        }
    }

    public static boolean respawnStructure(ServerLevel level, StructureData structureData, boolean checkLoaded) {
        StructurePiece piece;
        Iterator iterator;
        if (structureData == null) {
            return false;
        }
        if (checkLoaded && !level.m_7232_(structureData.pos.m_123170_(), structureData.pos.m_123222_())) {
            return false;
        }
        RespawnLevelData respawnData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        if (respawnData == null) {
            return false;
        }
        structureData.fillStructureStart(level);
        StructureStart structureStart = structureData.getStructureStart();
        if (structureStart == null || !structureStart.m_73603_()) {
            return false;
        }
        long time = System.nanoTime();
        BoundingBox boundingbox = structureStart.m_73601_();
        ChunkPos chunkPosMin = new ChunkPos(SectionPos.m_123171_((int)boundingbox.m_162395_()), SectionPos.m_123171_((int)boundingbox.m_162398_()));
        ChunkPos chunkPosMax = new ChunkPos(SectionPos.m_123171_((int)boundingbox.m_162399_()), SectionPos.m_123171_((int)boundingbox.m_162401_()));
        if (checkLoaded) {
            int z;
            int x;
            int loaded = 0;
            int unloaded = 0;
            for (x = chunkPosMin.f_45578_; x <= chunkPosMax.f_45578_; ++x) {
                for (z = chunkPosMax.f_45579_; z <= chunkPosMax.f_45579_; ++z) {
                    if (!level.m_7232_(x, z)) {
                        ++unloaded;
                        continue;
                    }
                    ++loaded;
                }
            }
            if (loaded > 0 && unloaded > 0) {
                for (x = chunkPosMin.f_45578_; x <= chunkPosMax.f_45578_; ++x) {
                    for (z = chunkPosMax.f_45579_; z <= chunkPosMax.f_45579_; ++z) {
                        if (level.m_7232_(x, z)) continue;
                        ChunkPos pos = new ChunkPos(x, z);
                        level.m_7726_().m_8387_(RESPAWN_TICKET, pos, 3, (Object)pos);
                    }
                }
                return false;
            }
            if (unloaded > 0) {
                return false;
            }
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).logRespawns) {
            RespawningStructures.LOGGER.info("Respawning structure: " + structureData.id + " at: " + structureData.pos.m_123249_() + " stats: " + structureData.getStats(level).getString());
        }
        respawnInProgress = structureData;
        respawnData.m_77762_();
        List entities = level.m_45976_(Entity.class, new AABB((double)boundingbox.m_162395_(), (double)boundingbox.m_162396_(), (double)boundingbox.m_162398_(), (double)boundingbox.m_162399_(), (double)boundingbox.m_162400_(), (double)boundingbox.m_162401_()).m_82400_(20.0));
        entityCounts = new Object2IntOpenHashMap();
        for (Entity existing : entities) {
            entityCounts.put((Object)existing.m_6095_(), entityCounts.getOrDefault((Object)existing.m_6095_(), 0) + 1);
        }
        for (StructurePiece piece2 : structureStart.m_73602_()) {
            if (checkLoaded) {
                if (!boundingbox.m_260866_(piece2.m_73547_().m_162399_(), piece2.m_73547_().m_162400_(), piece2.m_73547_().m_162401_()) && !level.m_7232_(piece2.m_73547_().m_162399_() >> 4, piece2.m_73547_().m_162401_() >> 4)) {
                    return false;
                }
                if (!boundingbox.m_260866_(piece2.m_73547_().m_162395_(), piece2.m_73547_().m_162396_(), piece2.m_73547_().m_162398_()) && !level.m_7232_(piece2.m_73547_().m_162395_() >> 4, piece2.m_73547_().m_162398_() >> 4)) {
                    return false;
                }
            }
            if (piece2 instanceof NetherFortressPieces.MonsterThrone) {
                ((NetherFortressPieces.MonsterThrone)piece2).f_228354_ = false;
            }
            if (piece2 instanceof StrongholdPieces.PortalRoom) {
                ((StrongholdPieces.PortalRoom)piece2).f_229627_ = false;
            }
            if (piece2 instanceof StrongholdPieces.ChestCorridor) {
                ((StrongholdPieces.ChestCorridor)piece2).f_229463_ = false;
            }
            if (piece2 instanceof MineshaftPieces.MineShaftCorridor) {
                ((MineshaftPieces.MineShaftCorridor)piece2).f_227728_ = false;
            }
            if (piece2 instanceof DesertPyramidPiece) {
                ((DesertPyramidPiece)piece2).f_227397_[0] = false;
                ((DesertPyramidPiece)piece2).f_227397_[1] = false;
                ((DesertPyramidPiece)piece2).f_227397_[2] = false;
                ((DesertPyramidPiece)piece2).f_227397_[3] = false;
            }
            if (piece2 instanceof JungleTemplePiece) {
                ((JungleTemplePiece)piece2).f_227661_ = false;
                ((JungleTemplePiece)piece2).f_227662_ = false;
            }
            if (piece2 instanceof NetherFortressPieces.CastleSmallCorridorLeftTurnPiece) {
                boolean bl = ((NetherFortressPieces.CastleSmallCorridorLeftTurnPiece)piece2).f_228230_ = RespawningStructures.rand.nextInt(3) == 0;
            }
            if (piece2 instanceof NetherFortressPieces.CastleSmallCorridorRightTurnPiece) {
                boolean bl = ((NetherFortressPieces.CastleSmallCorridorRightTurnPiece)piece2).f_228292_ = RespawningStructures.rand.nextInt(3) == 0;
            }
            if (!(piece2 instanceof IRemembersPositionPiece)) continue;
            ((IRemembersPositionPiece)piece2).setRespawnTemplatePos(((TemplateStructurePiece)piece2).m_226912_());
        }
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        Optional holder = structureRegistry.m_203300_(structureRegistry.m_7447_((Object)structureStart.m_226861_()));
        if (holder.isPresent() && ((Holder.Reference)holder.get()).m_203656_(StructureTags.f_215889_)) {
            ArrayList pieces = new ArrayList(structureStart.m_73602_());
            iterator = pieces.iterator();
            while (iterator.hasNext()) {
                piece = (StructurePiece)iterator.next();
                if (!piece.toString().contains("street")) continue;
                iterator.remove();
            }
            structureStart = new StructureStart(structureStart.m_226861_(), structureStart.m_163625_(), structureStart.m_73608_(), new PiecesContainer(pieces));
        }
        if (holder.isPresent() && ((Holder.Reference)holder.get()).m_205785_().m_135782_().toString().contains("stronghold")) {
            ArrayList pieces = new ArrayList(structureStart.m_73602_());
            iterator = pieces.iterator();
            while (iterator.hasNext()) {
                piece = (StructurePiece)iterator.next();
                if (!piece.toString().contains("portal") && !(piece instanceof StrongholdPieces.PortalRoom)) continue;
                iterator.remove();
            }
            structureStart = new StructureStart(structureStart.m_226861_(), structureStart.m_163625_(), structureStart.m_73608_(), new PiecesContainer(pieces));
        }
        StructureStart toPlace = structureStart;
        ChunkPos.m_45599_((ChunkPos)chunkPosMin, (ChunkPos)chunkPosMax).forEach(chunPos -> {
            toPlace.m_226850_((WorldGenLevel)level, level.m_215010_(), level.m_7726_().m_8481_(), level.m_213780_(), new BoundingBox(chunPos.m_45604_(), level.m_141937_(), chunPos.m_45605_(), chunPos.m_45608_(), level.m_151558_(), chunPos.m_45609_()), chunPos);
            level.m_6325_(chunPos.f_45578_, chunPos.f_45579_).m_62812_();
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(level.m_6325_(chunPos.f_45578_, chunPos.f_45579_), level.m_5518_(), null, null);
            for (ServerPlayer player : level.m_7726_().f_8325_.m_183262_(chunPos, false)) {
                player.f_8906_.m_9829_((Packet)packet);
            }
        });
        time = System.nanoTime() - time;
        if ((double)time / 1.0E9 > 20.0) {
            RespawningStructures.LOGGER.warn("Structure:" + structureData.id + " took over 20 seconds to respawn, if you want to avoid lagspikes it is recommended to put this ID on the blacklist:" + structureData.id);
        }
        structureData.onRespawnReset();
        respawnInProgress = null;
        heightMap = null;
        return true;
    }

    public static boolean tryAddEntityDuringRespawn(Entity entity, ServerLevel level, BlockPos pos) {
        if (respawnInProgress != null) {
            if (entityCounts.getInt((Object)entity.m_6095_()) > 0) {
                entityCounts.put((Object)entity.m_6095_(), entityCounts.getInt((Object)entity.m_6095_()) - 1);
                return false;
            }
            if (entity instanceof Mob && entity instanceof Enemy) {
                RespawnManager.applyRespawnBonus((Mob)entity, respawnInProgress);
            }
        }
        return true;
    }

    public static void onSpawnerSpawn(Mob entity) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)entity.m_9236_(), entity.m_20183_(), true);
        if (structureData != null && structureData.respawns > 0) {
            RespawnManager.applyRespawnBonus(entity, structureData);
        }
    }

    private static void applyRespawnBonus(Mob entity, StructureData structureData) {
        if (!((CommonConfiguration)RespawningStructures.config.getCommonConfig()).increaseDifficultyWithRespawn) {
            return;
        }
        int respawnDifficulty = Math.min(4, structureData.respawns);
        for (int i = 0; i < respawnDifficulty; ++i) {
            MobEffect randomEffect;
            ItemStack toEnchantItem = null;
            EquipmentSlot enchantItemSlot = null;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot == EquipmentSlot.OFFHAND || entity.m_6844_(slot).m_41619_() || !entity.m_6844_(slot).m_41785_().isEmpty()) continue;
                toEnchantItem = entity.m_6844_(slot);
                enchantItemSlot = slot;
                break;
            }
            if (toEnchantItem == null && RespawningStructures.rand.nextInt(10) == 0) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (!entity.m_6844_(slot).m_41619_() || slot == EquipmentSlot.OFFHAND) continue;
                    if (slot == EquipmentSlot.MAINHAND) {
                        toEnchantItem = Items.f_42383_.m_7968_();
                        enchantItemSlot = slot;
                        entity.m_8061_(slot, toEnchantItem);
                    }
                    if (slot == EquipmentSlot.CHEST) {
                        toEnchantItem = Items.f_42469_.m_7968_();
                        enchantItemSlot = slot;
                        entity.m_8061_(slot, toEnchantItem);
                    }
                    if (slot == EquipmentSlot.HEAD) {
                        toEnchantItem = Items.f_42468_.m_7968_();
                        enchantItemSlot = slot;
                        entity.m_8061_(slot, toEnchantItem);
                    }
                    if (slot == EquipmentSlot.LEGS) {
                        toEnchantItem = Items.f_42470_.m_7968_();
                        enchantItemSlot = slot;
                        entity.m_8061_(slot, toEnchantItem);
                    }
                    if (slot != EquipmentSlot.FEET) break;
                    toEnchantItem = Items.f_42471_.m_7968_();
                    enchantItemSlot = slot;
                    entity.m_8061_(slot, toEnchantItem);
                    break;
                }
            }
            if (toEnchantItem != null) {
                EnchantmentHelper.m_220292_((RandomSource)entity.m_217043_(), toEnchantItem, (int)respawnDifficulty, (boolean)true);
                entity.m_21409_(enchantItemSlot, 0.3f);
            }
            if (RespawningStructures.rand.nextInt(4) != 0 || entity.m_21023_(randomEffect = randomEffects.get(RespawningStructures.rand.nextInt(randomEffects.size())))) continue;
            entity.m_7292_(new MobEffectInstance(randomEffect, -1));
        }
    }

    private static /* synthetic */ Respawn lambda$onPlayerRespawn$1(ServerPlayer entity, RespawnLevelData levelData, UUID uuid) {
        return new Respawn(uuid, entity.m_8961_(), levelData.getLevelTime());
    }

    private static /* synthetic */ Respawn lambda$onPlayerLogin$0(ServerPlayer entity, RespawnLevelData levelData, UUID uuid) {
        return new Respawn(uuid, entity.m_8961_(), levelData.getLevelTime());
    }
}

