/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.structure.Respawn;
import com.respawningstructures.structure.StructureData;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.saveddata.SavedData;

public class RespawnLevelData
extends SavedData {
    public static final String ID = "respawningdungeonsdata";
    private final Long2ObjectOpenHashMap<StructureData> structurePositions = new Long2ObjectOpenHashMap();
    private final Set<StructureData> allStructureData = new HashSet<StructureData>();
    public final Map<UUID, Respawn> playerRespawnTracker = new HashMap<UUID, Respawn>();
    private long elapsedTime = 5L;

    public static RespawnLevelData load(CompoundTag tag) {
        RespawnLevelData data = new RespawnLevelData();
        data.read(tag);
        return data;
    }

    public void read(CompoundTag nbt) {
        this.elapsedTime = nbt.m_128454_("elapsedTime");
        ListTag list = nbt.m_128437_("Structures", 10);
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            StructureData data = new StructureData((CompoundTag)tag);
            this.structurePositions.put(data.pos.m_123252_(), (Object)data);
            this.allStructureData.add(data);
        }
        if (nbt.m_128441_("playerrespawns")) {
            ListTag respawnList = nbt.m_128437_("playerrespawns", 10);
            for (Tag tag : respawnList) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)tag;
                Respawn respawn = new Respawn(compoundTag);
                this.playerRespawnTracker.put(respawn.playerUUID, respawn);
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128356_("elapsedTime", this.elapsedTime);
        ListTag list = new ListTag();
        for (StructureData data : this.allStructureData) {
            if (data == StructureData.EMPTY) continue;
            list.add((Object)data.serializeNbt());
        }
        nbt.m_128365_("Structures", (Tag)list);
        ListTag respawnList = new ListTag();
        for (Map.Entry<UUID, Respawn> data : this.playerRespawnTracker.entrySet()) {
            if (data == null) continue;
            respawnList.add((Object)data.getValue().toNbt());
        }
        nbt.m_128365_("playerrespawns", (Tag)respawnList);
        return nbt;
    }

    public StructureData getForPos(ServerLevel level, BlockPos pos) {
        return this.getForPos(level, pos, true);
    }

    public StructureData getForPos(ServerLevel level, BlockPos pos, boolean update) {
        StructureData alreadyContainedAtPos = (StructureData)this.structurePositions.get(SectionPos.m_175568_((BlockPos)pos));
        if (alreadyContainedAtPos == StructureData.EMPTY) {
            return null;
        }
        if (alreadyContainedAtPos != null) {
            if (update) {
                alreadyContainedAtPos.setLastModifiedTime(this.elapsedTime);
                this.m_77760_(true);
            }
            return alreadyContainedAtPos;
        }
        StructureStart structureStart = RespawnLevelData.getClosestStart(level, pos);
        if (structureStart == null) {
            this.structurePositions.put(SectionPos.m_175568_((BlockPos)pos), (Object)StructureData.EMPTY);
            return null;
        }
        StructureData data = (StructureData)this.structurePositions.computeIfAbsent(SectionPos.m_175568_((BlockPos)structureStart.m_73601_().m_162394_()), p -> {
            StructureData newData = new StructureData(structureStart.m_73601_().m_162394_(), ((Registry)level.m_9598_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)structureStart.m_226861_()));
            newData.inhabitedStart = level.m_6325_(newData.pos.m_123170_(), newData.pos.m_123222_()).m_6319_();
            this.allStructureData.add(newData);
            return newData;
        });
        this.structurePositions.put(SectionPos.m_175568_((BlockPos)pos), (Object)data);
        this.m_77760_(true);
        data.setStructureStart(structureStart);
        if (update) {
            data.setLastModifiedTime(this.elapsedTime);
        }
        return data;
    }

    public static StructureStart getClosestStart(ServerLevel level, BlockPos pos) {
        HashMap<Structure, LongSet> structures = null;
        ChunkPos start = new ChunkPos(pos);
        for (Map.Entry entry : level.m_215010_().m_220522_(new BlockPos(start.f_45578_ << 4, 0, start.f_45579_ << 4)).entrySet()) {
            if (structures == null) {
                structures = new HashMap<Structure, LongSet>();
            }
            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
        }
        if (structures == null || structures.isEmpty()) {
            for (int x = -2; x < 2; ++x) {
                for (int z = -2; z < 2; ++z) {
                    if (x == 0 && z == 0 || !level.m_7232_(start.f_45578_ + x, start.f_45579_ + z)) continue;
                    for (Map.Entry entry : level.m_215010_().m_220522_(new BlockPos(start.f_45578_ + x << 4, 0, start.f_45579_ + z << 4)).entrySet()) {
                        if (structures == null) {
                            structures = new HashMap();
                        }
                        structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                    }
                }
            }
        }
        if (structures == null || structures.isEmpty()) {
            return null;
        }
        StructureStart[] closest = new StructureStart[1];
        for (Map.Entry structureEntry : structures.entrySet()) {
            level.m_215010_().m_220480_((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> {
                if (pos.equals((Object)structureStart.m_73601_().m_162394_()) && (closest[0] == null || closest[0].m_73601_().m_162394_().m_123331_((Vec3i)pos) > structureStart.m_73601_().m_162394_().m_123331_((Vec3i)pos))) {
                    closest[0] = structureStart;
                }
                for (StructurePiece piece : structureStart.m_73602_()) {
                    if (piece == null || !piece.m_73547_().m_71051_((Vec3i)pos)) continue;
                    if (closest[0] != null && !(closest[0].m_73601_().m_162394_().m_123331_((Vec3i)pos) > structureStart.m_73601_().m_162394_().m_123331_((Vec3i)pos))) break;
                    closest[0] = structureStart;
                    break;
                }
            });
        }
        return closest[0];
    }

    public void increaseTime(int seconds) {
        this.elapsedTime += (long)seconds;
        this.m_77760_(true);
    }

    public long getLevelTime() {
        return this.elapsedTime;
    }

    public Set<StructureData> getAllStructureData() {
        return this.allStructureData;
    }
}

