/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import com.respawningstructures.structure.StructureData;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class Command {
    public LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"respawningstructures").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"respawnClosestStructure").requires(stack -> stack.m_6761_(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()));
            for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ << 4, 0, start.f_45579_ << 4)).entrySet()) {
                structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
            }
            if (structures.isEmpty()) {
                for (int x = -5; x < 5; ++x) {
                    for (int z = -5; z < 5; ++z) {
                        for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ + x << 4, 0, start.f_45579_ + z << 4)).entrySet()) {
                            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                        }
                    }
                }
            }
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.m_215010_().m_220480_((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.m_73601_().m_162394_(), structureStart));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).m_123331_((Vec3i)BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()))));
            if (sortedStructures.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"No Structure nearby, anything visible nearby is not an actual structure but just a feature, those can't respawn").m_130940_(ChatFormatting.RED));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Respawning structure: " + ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)((StructureStart)((Map.Entry)sortedStructures.get(0)).getValue()).m_226861_()))).m_7220_((Component)Component.m_237113_((String)(" at: " + ((Map.Entry)sortedStructures.get(0)).getKey())).m_130940_(ChatFormatting.YELLOW).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).m_123341_() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).m_123342_() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).m_123343_())))));
            RespawnManager.respawnStructure(world, RespawnManager.getForPos(world, ((StructureStart)((Map.Entry)sortedStructures.get(0)).getValue()).m_73601_().m_162394_(), false), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setClosestStructureRespawningFlag").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"doesrespawn", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean shouldRespawn = BoolArgumentType.getBool((CommandContext)context, (String)"doesrespawn");
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()));
            for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ << 4, 0, start.f_45579_ << 4)).entrySet()) {
                structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
            }
            if (structures.isEmpty()) {
                for (int x = -5; x < 5; ++x) {
                    for (int z = -5; z < 5; ++z) {
                        for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ + x << 4, 0, start.f_45579_ + z << 4)).entrySet()) {
                            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                        }
                    }
                }
            }
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.m_215010_().m_220480_((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.m_73601_().m_162394_(), structureStart));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).m_123331_((Vec3i)BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()))));
            if (sortedStructures.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"No Structure nearby, anything visible nearby is not an actual structure but just a feature, those can't respawn").m_130940_(ChatFormatting.RED));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Set respawn to " + shouldRespawn + " for structure: " + ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)((StructureStart)((Map.Entry)sortedStructures.get(0)).getValue()).m_226861_()))).m_7220_((Component)Component.m_237113_((String)(" at: " + ((Map.Entry)sortedStructures.get(0)).getKey())).m_130940_(ChatFormatting.YELLOW).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).m_123341_() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).m_123342_() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).m_123343_())))));
            RespawnManager.getForPos((ServerLevel)world, (BlockPos)((StructureStart)((Map.Entry)sortedStructures.get((int)0)).getValue()).m_73601_().m_162394_(), (boolean)false).disabledRespawn = !shouldRespawn;
            RespawnLevelData respawnData = (RespawnLevelData)((CommandSourceStack)context.getSource()).m_81372_().m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
            if (respawnData != null) {
                respawnData.m_77762_();
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"listNearbyStructures").requires(stack -> stack.m_6761_(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()));
            for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ << 4, 0, start.f_45579_ << 4)).entrySet()) {
                structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
            }
            if (structures.isEmpty()) {
                for (int x = -5; x < 5; ++x) {
                    for (int z = -5; z < 5; ++z) {
                        for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ + x << 4, 0, start.f_45579_ + z << 4)).entrySet()) {
                            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                        }
                    }
                }
            }
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.m_215010_().m_220480_((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.m_73601_().m_162394_(), structureStart));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).m_123331_((Vec3i)BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()))));
            if (sortedStructures.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"No Structure nearby, anything visible nearby is not an actual structure but just a feature, those can't respawn").m_130940_(ChatFormatting.RED));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"Structures: ").m_130940_(ChatFormatting.BLUE));
            for (Map.Entry entry : sortedStructures) {
                StructureData data = RespawnManager.getForPos(((CommandSourceStack)context.getSource()).m_81372_(), (BlockPos)entry.getKey(), false);
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("" + data.id)).m_7220_((Component)Component.m_237113_((String)(" at: {" + ((BlockPos)entry.getKey()).m_123344_() + "}")).m_130940_(ChatFormatting.YELLOW).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)entry.getKey()).m_123341_() + " " + ((BlockPos)entry.getKey()).m_123342_() + " " + ((BlockPos)entry.getKey()).m_123343_()))).m_7220_((Component)Component.m_237113_((String)" {stats}").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/respawningstructures structureRespawnStatus " + ((BlockPos)entry.getKey()).m_123341_() + " " + ((BlockPos)entry.getKey()).m_123342_() + " " + ((BlockPos)entry.getKey()).m_123343_()))))));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"structureRespawnStatus").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"position");
            StructureData data = RespawnManager.getForPos(((CommandSourceStack)context.getSource()).m_81372_(), pos, false);
            if (data == null) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"No structure at this position"));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Structure: " + data.id)).m_130940_(ChatFormatting.YELLOW));
            StructureData.RespawnStatus status = data.canRespawn(((CommandSourceStack)context.getSource()).m_81372_());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Respawn status: " + status)).m_130940_(status.isBlocked() ? ChatFormatting.RED : ChatFormatting.YELLOW));
            int minutes_remaining = Math.max(0, (int)(0.016666666666666666 * (double)((long)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).minutesUntilRespawn * 60L - (((RespawnLevelData)((CommandSourceStack)context.getSource()).m_81372_().m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata")).getLevelTime() - data.lastActivity))));
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Remaining minutes until respawn: " + minutes_remaining)).m_130940_(minutes_remaining == 0 ? ChatFormatting.GREEN : ChatFormatting.RED));
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"Statistics:").m_130940_(ChatFormatting.YELLOW));
            ((CommandSourceStack)context.getSource()).m_243053_(data.getStats(((CommandSourceStack)context.getSource()).m_81372_()));
            return 1;
        })));
    }
}

