/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.cerbonsapi_fix.mixin;

import com.cerbon.cerbons_api.platform.Services;
import com.cerbon.cerbons_api.util.Constants;
import java.util.ServiceLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Services.class}, remap=false)
public abstract class ServicesMixin {
    @Inject(method={"load"}, at={@At(value="HEAD")}, cancellable=true)
    private static <T> void load(Class<T> clazz, CallbackInfoReturnable<T> cir) {
        T loadedService = ServiceLoader.load(clazz, clazz.getClassLoader()).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        cir.setReturnValue(loadedService);
    }
}

