/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import nonamecrackers2.endertrigon.common.config.EnderTrigonConfig;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.TargetPhase;
import nonamecrackers2.endertrigon.common.init.EnderTrigonDragonPhases;
import nonamecrackers2.endertrigon.common.util.EnderDragonHelper;

public class DragonCrashPlayerPhase
extends AbstractDragonPhaseInstance
implements TargetPhase {
    private static final int MAX_CHARGE_TIME = 180;
    @Nullable
    private LivingEntity target;
    private int timeSinceCharge;

    public DragonCrashPlayerPhase(EnderDragon dragon) {
        super(dragon);
    }

    public void m_6991_() {
        if (this.f_31176_.f_31083_) {
            this.f_31176_.m_9236_().m_7785_(this.f_31176_.m_20185_(), this.f_31176_.m_20186_(), this.f_31176_.m_20189_(), SoundEvents.f_11894_, this.f_31176_.m_5720_(), 10.0f, 0.8f + this.f_31176_.m_217043_().m_188501_() * 0.3f, false);
        }
    }

    public void m_6989_() {
        if (this.target != null) {
            EnderDragonHelper.moveUnrestrictedY(this.f_31176_, this.target.m_20182_().m_82520_(0.0, -2.0, 0.0), this.m_7089_(), 0.5f, 0.9);
            ++this.timeSinceCharge;
            if (this.f_31176_.f_31083_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_31176_.m_9236_(), (Entity)this.f_31176_)) {
                Explosion explosion = this.f_31176_.m_9236_().m_254849_((Entity)this.f_31176_, this.f_31176_.m_20185_(), this.f_31176_.m_20186_(), this.f_31176_.m_20189_(), 7.0f, Level.ExplosionInteraction.NONE);
                if (((Boolean)EnderTrigonConfig.COMMON.crashPhaseDestroysBlocks.get()).booleanValue()) {
                    int radius = 3;
                    for (int x = -radius; x < radius; ++x) {
                        for (int z = -radius; z < radius; ++z) {
                            BlockPos pos = BlockPos.m_274561_((double)(this.f_31176_.m_20185_() + (double)x), (double)0.0, (double)(this.f_31176_.m_20189_() + (double)z));
                            pos = this.f_31176_.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos).m_7495_();
                            BlockState state = this.f_31176_.m_9236_().m_8055_(pos);
                            FluidState fluid = this.f_31176_.m_9236_().m_6425_(pos);
                            ExplosionDamageCalculator calculator = new ExplosionDamageCalculator();
                            Optional resistance = calculator.m_6617_(explosion, (BlockGetter)this.f_31176_.m_9236_(), pos, state, fluid);
                            if (!resistance.isPresent() || state.m_60795_() || !(((Float)resistance.get()).floatValue() < 20.0f) || this.f_31176_.m_217043_().m_188503_(12) != 0) continue;
                            FallingBlockEntity block = FallingBlockEntity.m_201971_((Level)this.f_31176_.m_9236_(), (BlockPos)pos, (BlockState)state);
                            block.f_31942_ = 560;
                            double xDelta = block.m_20185_() - this.f_31176_.m_20185_();
                            double zDelta = block.m_20189_() - this.f_31176_.m_20189_();
                            Vec3 delta = new Vec3(xDelta, 3.0, zDelta).m_82541_().m_82490_(0.8);
                            block.m_20256_(delta);
                        }
                    }
                }
            }
            if (this.timeSinceCharge > 180) {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
            }
        } else {
            this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
        }
    }

    public void m_7083_() {
        this.target = null;
        this.timeSinceCharge = 0;
    }

    @Override
    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
    }

    public EnderDragonPhase<DragonCrashPlayerPhase> m_7309_() {
        return EnderTrigonDragonPhases.getPhase("CrashPlayer").get();
    }
}

