/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.common.entity;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.endertrigon.common.entity.goal.BabyEnderDragonAttackStrategyGoal;
import nonamecrackers2.endertrigon.common.entity.goal.BabyEnderDragonFollowOwnerGoal;
import nonamecrackers2.endertrigon.common.entity.goal.BabyEnderDragonMoveAnchorGoal;
import nonamecrackers2.endertrigon.common.entity.goal.BabyEnderDragonSweepGoal;
import nonamecrackers2.endertrigon.common.init.EnderTrigonEntityTypes;

public class BabyEnderDragon
extends ShoulderRidingEntity
implements NeutralMob,
FlyingAnimal {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BabyEnderDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDimensions SITTING = EntityDimensions.m_20398_((float)0.9f, (float)0.85f);
    public float flapTime;
    public float oFlapTime;
    public final double[][] latencyYs = new double[64][3];
    public int latencyPointer = -1;
    private Vec3 moveTarget = Vec3.f_82478_;
    private BlockPos anchor = BlockPos.f_121853_;
    private Phase phase = Phase.CIRCLE;
    @Nullable
    private UUID persistentAngerTarget;
    private final TargetGoal<Monster> monsterTargeting = new TargetGoal<Monster>(this, Monster.class, l -> l instanceof Zombie || l instanceof Spider || l instanceof AbstractSkeleton || l instanceof Pillager || l instanceof Phantom);

    public BabyEnderDragon(EntityType<? extends BabyEnderDragon> type, Level level) {
        super(type, level);
        this.f_21365_ = new DragonLookControl(this);
        this.f_21342_ = new DragonMoveControl(this);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    protected BodyRotationControl m_7560_() {
        return new DragonBodyControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BabyEnderDragonFollowOwnerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BabyEnderDragonAttackStrategyGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BabyEnderDragonSweepGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BabyEnderDragonMoveAnchorGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new TargetGoal<Player>(this, Player.class, l -> !this.m_21824_()));
    }

    public void m_7105_(boolean flag) {
        if (flag != this.m_21824_()) {
            if (flag) {
                this.f_21346_.m_25352_(5, this.monsterTargeting);
            } else {
                this.f_21346_.m_25363_(this.monsterTargeting);
            }
        }
        super.m_7105_(flag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)this.getAnchor()));
        tag.m_128405_("Phase", this.phase.ordinal());
        if (this.moveTarget != null) {
            CompoundTag moveTargetTag = new CompoundTag();
            moveTargetTag.m_128347_("x", this.moveTarget.f_82479_);
            moveTargetTag.m_128347_("y", this.moveTarget.f_82480_);
            moveTargetTag.m_128347_("z", this.moveTarget.f_82481_);
            tag.m_128365_("MoveTarget", (Tag)moveTargetTag);
        }
    }

    public void m_7378_(CompoundTag tag) {
        int ordinal;
        super.m_7378_(tag);
        this.setAnchor(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Anchor")));
        if (tag.m_128425_("Phase", 3) && (ordinal = tag.m_128451_("Phase")) > 0 && ordinal < Phase.values().length) {
            this.phase = Phase.values()[ordinal];
        }
        if (tag.m_128425_("MoveTarget", 10)) {
            Vec3 vec;
            CompoundTag moveTargetTag = tag.m_128469_("MoveTarget");
            this.moveTarget = vec = new Vec3(moveTargetTag.m_128459_("x"), moveTargetTag.m_128459_("y"), moveTargetTag.m_128459_("z"));
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, damage);
        }
        if (this.m_21824_()) {
            return super.m_6469_(source, damage * 0.25f);
        }
        return super.m_6469_(source, damage);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    protected void m_7840_(double amount, boolean flag, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 delta) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, delta);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, delta);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                BlockPos ground = this.m_20099_();
                float f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                }
                this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, delta);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)f));
            }
        }
        this.m_267651_(false);
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_142039_() {
        float f = Mth.m_14089_((float)(this.flapTime * ((float)Math.PI * 2)));
        float f1 = Mth.m_14089_((float)(this.oFlapTime * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f >= -0.3f;
    }

    public void m_142043_() {
        if (this.m_9236_().f_46443_ && !this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11893_, this.m_5720_(), 5.0f, 1.7f + this.f_19796_.m_188501_() * 0.3f, false);
        }
    }

    public double[] getLatency(int pointer, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.latencyPointer - pointer & 0x3F;
        int j = this.latencyPointer - pointer - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.latencyYs[i][0];
        double d1 = Mth.m_14175_((double)(this.latencyYs[j][0] - d0));
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.latencyYs[i][1];
        d1 = this.latencyYs[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)partialTicks, (double)this.latencyYs[i][2], (double)this.latencyYs[j][2]);
        return adouble;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_()) {
            this.m_21837_(true);
            this.m_20124_(Pose.SITTING);
        } else {
            this.m_21837_(false);
            this.m_20124_(Pose.STANDING);
        }
    }

    public boolean m_21827_() {
        return this.getPhase() == Phase.LAND;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (pose == Pose.SITTING) {
            return SITTING;
        }
        return super.m_6972_(pose);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21224_()) {
            if (this.latencyPointer < 0) {
                for (int i = 0; i < this.latencyYs.length; ++i) {
                    this.latencyYs[i][0] = this.m_146908_();
                    this.latencyYs[i][1] = this.m_20186_();
                }
            }
            if (++this.latencyPointer == this.latencyYs.length) {
                this.latencyPointer = 0;
            }
            this.latencyYs[this.latencyPointer][0] = this.m_146908_();
            this.latencyYs[this.latencyPointer][1] = this.m_20186_();
        }
        this.oFlapTime = this.flapTime;
        Vec3 delta = this.m_20184_();
        if (!this.m_20096_()) {
            float flapPower = 0.2f / ((float)delta.m_165924_() * 2.0f + 1.0f);
            this.flapTime += flapPower;
        }
        if (this.m_9236_().m_5776_()) {
            this.m_146874_();
        }
        if (!this.m_9236_().m_5776_() && this.m_21824_()) {
            LivingEntity owner;
            if (this.f_19797_ % (this.m_21825_() ? 20 : 80) == 0) {
                this.m_5634_(0.5f);
            }
            if ((owner = this.m_269323_()) != null && EntitySelector.f_20408_.test(owner) && !this.m_21827_() && (double)this.m_20270_((Entity)owner) > 64.0) {
                this.teleportToOwner();
            }
        }
    }

    private void teleportToOwner() {
        LivingEntity owner = this.m_269323_();
        if (owner != null) {
            BlockPos blockpos = owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean flag = this.maybeTeleportTo(owner, blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }
    }

    private int randomIntInclusive(int min, int max) {
        return this.m_217043_().m_188503_(max - min + 1) + min;
    }

    private boolean maybeTeleportTo(LivingEntity owner, int x, int y, int z) {
        if (Math.abs((double)x - owner.m_20185_()) < 2.0 && Math.abs((double)z - owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.m_146908_(), this.m_146909_());
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.m_20183_());
        return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82338_(blockpos));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11895_;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    public Vec3 getMoveTarget() {
        return this.moveTarget;
    }

    public void setMoveTarget(Vec3 moveTarget) {
        this.moveTarget = moveTarget;
    }

    public BlockPos getAnchor() {
        return this.anchor;
    }

    public void setAnchor(BlockPos anchor) {
        this.anchor = anchor;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    protected boolean m_8028_() {
        return !this.m_21824_();
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID id) {
        this.persistentAngerTarget = id;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return !this.m_21660_() && super.m_6573_(player);
    }

    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
    }

    protected int m_7302_(int supply) {
        return supply;
    }

    public boolean m_6549_(EntityType<?> type) {
        return type != EnderTrigonEntityTypes.BABY_ENDER_DRAGON.get() && super.m_6549_(type);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, SpawnGroupData groupData, CompoundTag data) {
        this.setAnchor(this.m_20183_().m_6630_(5));
        return super.m_6518_(level, difficulty, type, groupData, data);
    }

    public static enum Phase {
        CIRCLE,
        SWOOP,
        LAND;

    }

    private static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(BabyEnderDragon dragon, Class<T> clazz, Predicate<LivingEntity> predicate) {
            super((Mob)dragon, clazz, false, predicate);
        }

        protected AABB m_7255_(double reach) {
            return this.f_26135_.m_20191_().m_82400_(reach);
        }
    }

    private static class DragonLookControl
    extends LookControl {
        public DragonLookControl(BabyEnderDragon dragon) {
            super((Mob)dragon);
        }

        public void m_8128_() {
        }
    }

    private static class DragonMoveControl
    extends MoveControl {
        private final BabyEnderDragon dragon;
        private float speed;

        public DragonMoveControl(BabyEnderDragon dragon) {
            super((Mob)dragon);
            this.dragon = dragon;
        }

        public void m_8126_() {
            double deltaX = this.dragon.moveTarget.f_82479_ - this.dragon.m_20185_();
            double deltaY = this.dragon.moveTarget.f_82480_ - this.dragon.m_20186_();
            double deltaZ = this.dragon.moveTarget.f_82481_ - this.dragon.m_20189_();
            double horizontalDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double dist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ + deltaY * deltaY);
            if (Math.abs(horizontalDist) > (double)1.0E-5f) {
                if (this.dragon.getPhase() != Phase.LAND) {
                    double d4 = 1.0 - Math.abs(deltaY * (double)0.7f) / horizontalDist;
                    horizontalDist = Math.sqrt((deltaX *= d4) * deltaX + (deltaZ *= d4) * deltaZ);
                }
                float f = this.dragon.m_146908_();
                float f1 = (float)Mth.m_14136_((double)deltaZ, (double)deltaX);
                float f2 = Mth.m_14177_((float)(this.dragon.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                this.dragon.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)(this.dragon.m_21824_() ? 10.0f : 4.0f)) - 90.0f);
                this.dragon.f_20883_ = this.dragon.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)this.dragon.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.8f, (float)0.25f);
                float f4 = (float)(-(Mth.m_14136_((double)(-deltaY), (double)horizontalDist) * 57.2957763671875));
                this.dragon.m_146926_(f4);
                float f5 = this.dragon.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(deltaX / dist);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(deltaZ / dist);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(deltaY / dist);
                Vec3 vec3 = this.dragon.m_20184_();
                if (horizontalDist < 1.0 && this.dragon.getPhase() == Phase.LAND) {
                    this.dragon.m_20256_(vec3.m_82520_(0.0, -0.5, 0.0).m_82546_(vec3).m_82490_(0.2));
                } else {
                    this.dragon.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
                }
            }
        }
    }

    private static class DragonBodyControl
    extends BodyRotationControl {
        private final BabyEnderDragon dragon;

        public DragonBodyControl(BabyEnderDragon dragon) {
            super((Mob)dragon);
            this.dragon = dragon;
        }

        public void m_8121_() {
            this.dragon.f_20885_ = this.dragon.f_20883_;
            this.dragon.f_20883_ = this.dragon.m_146908_();
        }
    }
}

